<?php

function getProjectName($projectId)
{
    global $db;
    return $db->get('_Projects',$projectId,'proj_name',DB_WARPIT_WEBCATI_BASE);
}

function getProjectId($projectName)
{
    global $db;

    $projectData = $db->get('_Projects', "proj_name = '{$projectName}'", 'id', DB_WARPIT_WEBCATI_BASE);
    return (int)array_shift($projectData);
}

function getRedirectProjectName($projectId)
{
    global $db;
    return $db->get('_RedirectProjects',$projectId, 'idLab', DB_WARPIT_USERSPOOL);
}

function getProjectProperty($projectId, $propertyName, $defaultValue = null)
{
    global $db;
    static $properties = [];

    if(key_exists($projectId, $properties) === false) {
        $properties[$projectId] = $db->get('_Projects',$projectId, '*', DB_WARPIT_WEBCATI_BASE);
    }

    if(key_exists($propertyName, $properties[$projectId]) === true) {
        return $properties[$projectId][$propertyName];
    }

    return $defaultValue;
}

function getRedirectProjectId($projectName)
{
    global $db;
    $projectData =  $db->get('_RedirectProjects',"idLab = '{$projectName}'", 'id', DB_WARPIT_USERSPOOL);
    return (int) array_shift($projectData);
}

function getQuestionId($projectName, $questionName)
{
    global $db;

    $question = $db->get($projectName,"q_name = '$questionName'", 'id', DB_WARPIT_WEBCATI);
    return array_shift($question);
}

function getTelephoneTableId($projectId)
{
    global $db;

    $projectName    = getProjectName($projectId);
    $dialerQuestion = getQuestionId($projectName,'dialer');

    // Because of the bug in warpit on remove dialer, we can't only check ID telname in projects we also need to check
    // if dialer question exists
    //  https://gitlab.solve-x.net/warpit/warpit/issues/195
    if($dialerQuestion === null){
        return null;
    }

    return (int)$db->get('_Projects',$projectId,'id_telname',DB_WARPIT_WEBCATI_BASE);
}

function getTelephoneTableName($projectId)
{
    global $db;

    $telephoneTableId = getTelephoneTableId($projectId);

    if($telephoneTableId === null){
        return null;
    }

    return 'tel___' . $db->get('_TelephoneTables', $telephoneTableId, 'name', DB_WARPIT_WEBCATI_BASE);
}

function getTelephoneDataRecord($projectId, $telId)
{
    $telephoneTableName = getTelephoneTableName($projectId);
    $telephoneTableName = 'tel___' .$telephoneTableName;

    global $db;
    return $db->get($telephoneTableName, $telId, '*', DB_WARPIT_WEBCATI_BASE);
}

function getTelephoneSampleDataRecord($projectId, $telIndexId)
{
    $sampleTable = getProjectName($projectId);
    $sampleTable .= '___telIndex';

    global $db;
    return $db->get($sampleTable, $telIndexId, '*', DB_WARPIT_WEBCATI_BASE);
}

function getTableFields($telephoneTableId)
{
    global $db;

    $fields = $db->get('_TelephoneTablesAddon', "id_telbaza=$telephoneTableId", 'name', DB_WARPIT_WEBCATI_BASE);

    if(!is_array($fields)){
        return [$fields];
    }

    return $fields;
}

function quotaLockExists($projectId)
{
    global $db;

    $projectName = getProjectName($projectId);
    $quotaLockTable = "{$projectName}___quotaLock";

    return $db->TableExists($quotaLockTable);
}
