<?php

use Phinx\Migration\AbstractMigration;

class AddSlideToScalePlugin extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $this->query("CREATE TABLE " . DB_WARPIT_WEBCATI_BASE . ".`_plugin_dragtoscale` (
                    	`id` INT(11) NOT NULL AUTO_INCREMENT,
                    	`id_project` INT(11) NOT NULL,
                    	`id_question` INT(11) NOT NULL,
                    	`background_color` VARCHAR(20) NULL DEFAULT 'rgba(0,0,0,.03)' COLLATE 'utf8_unicode_ci',
                    	`border_color` VARCHAR(50) NULL DEFAULT 'solid 1px  #dedede' COLLATE 'utf8_unicode_ci',
                    	`deleted` TINYINT(1) NOT NULL DEFAULT '0',
                    	PRIMARY KEY (`id`),
                    	UNIQUE INDEX `id_project` (`id_project`, `id_question`)
                    )
                    COLLATE='utf8_unicode_ci'
                    ENGINE=MyISAM
                    ROW_FORMAT=DYNAMIC
                    AUTO_INCREMENT=8");

        $this->query("INSERT INTO " . DB_WARPIT_WEBCATI_BASE . ".`_Plugin` (`id_plugin`, `plugin_name`, `plugin_path`, `short_name`) VALUES (105, 'Drag to scale', 'dragtoscale', 'dt')");

        $this->query("INSERT INTO " . DB_WARPIT_WEBCATI_BASE . ".`_Plugin_label` (`id_label`, `name`, `label`, `type`, `default_value`, `group`, `id_plugin`) VALUES (null, 'background_color', 'Bacground color', 'string', 'rgba(0,0,0,.03)', 'Basic settings', 105)");
        $this->query("INSERT INTO " . DB_WARPIT_WEBCATI_BASE . ".`_Plugin_label` (`id_label`, `name`, `label`, `type`, `default_value`, `group`, `id_plugin`) VALUES (null, 'border_color', 'Border color', 'string', 'solid 1px  #dedede', 'Basic settings', 105)");



    }
}
