<?php

use Phinx\Migration\AbstractMigration;

class AddQuotaLastImportTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $tableName = DB_WARPIT_WEBCATI_BASE . ".`_QuotaLastImport`";
        $sql = "CREATE TABLE $tableName (
        	`id` INT(11) NOT NULL AUTO_INCREMENT,
        	`id_project` INT(11) NOT NULL,
        	`upload_time` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
        	`file_content` TEXT NULL COLLATE 'utf8_unicode_ci',
        	PRIMARY KEY (`id`)
        )
        COLLATE='utf8_unicode_ci'
        ENGINE=InnoDB";

        $this->execute($sql);
    }
}
