<?php

namespace DataContainers;

class CurrentProject
{
    private static $instance;

    private $projectsToUpload = array();

    private $currentProject;

    private $loaded = false;

    public function setProjects(array $id_project)
    {
        $this->projectsToUpload = $id_project;
        $this->isLoaded(true);
    }

    public function next()
    {
        $this->currentProject = array_shift($this->projectsToUpload);
        return $this->current();
    }

    public function current($property = null)
    {
        if ($this->currentProject) {
            if (is_null($property))
                return $this->currentProject;
            else
                return $this->currentProject[$property];
        }

        return false;
    }

    public function getIdProject()
    {
        return $this->current('id_project');
    }

    public function isLoaded($value = null)
    {
        if (!is_null($value)) $this->loaded = $value;

        return $this->loaded;
    }

    public function hasNext()
    {
        return $this->isLoaded() && $this->next();
    }


}
