<?php

namespace DataContainers;

class ActionData
{

    const FILETYPE_WARPIT = "warpit";

    const FILETYPE_WEBPROJECTS = "webprojects";

    private $filesList = array();

    private $statmentsList = array();

   // private $xml = '';

    private $uploadedRecords = array();

    private $noUpload = true;

    private $serverLogId = 0;

    public function addFile($fileName, $fileType)
    {
        $this->filesList[$fileType][] = $fileName;
    }

    public function addSQLStatment($dbName, array $statement)
    {
        $this->statmentsList[$dbName] = $statement;
    }

    public function getFiles($fileType = null)
    {
        if(is_null($fileType))
          return $this->filesList;

        return $this->filesList[$fileType];
    }

    public function getSQLs()
    {

        return $this->statmentsList;
    }

    public function clean()
    {
        $this->filesList = array();
        $this->statmentsList = array();
    }

    public function noUploadMsg()
    {
        return $this->noUpload;
    }

    public function resetNoUpload()
    {
        $this->noUpload = false;
    }

    public function addXml($xml)
    {
        $this->resetNoUpload();
        $this->xml = $xml;
    }

    public function getXml()
    {
        return $this->xml;
    }

    public function addRecordsForUpload($table, $records)
    {
        $this->uploadedRecords[$table]['forUpload'] = $records;
    }

    public function addUploadedRecords($table, $records)
    {
        $this->uploadedRecords[$table]['uploaded'] = $records;
    }

    public function addMsg($table, $msg)
    {
        $this->uploadedRecords[$table]['msg'] = $msg;
    }

    public function getUploaded()
    {
        return $this->uploadedRecords;
    }

    public function cleanUploaded()
    {
        $this->uploadedRecords = array();
    }

    public function saveXmlToFile($fileName)
    {
        file_put_contents($fileName, $this->xml);
    }

    public function setLogId($id)
    {
        $this->serverLogId = $id;
    }

    public function getLogId()
    {
        return $this->serverLogId;
    }
}


 ?>
