<?php
header ("Content-type: text/json; charset=utf-8");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

date_default_timezone_set('Europe/Ljubljana');
ini_set('display_errors', 0);     # don't show any errors...
error_reporting(E_ERROR | E_WARNING | E_PARSE);  # ...but do log them

include '_dirinfo.php';
include_once(PATH_TO_ROOT."webcati/_class/class.SurveySession.php");
include_once(PATH_TO_ROOT."_support/class.db.php");
include_once(PATH_TO_ROOT."webcati/_class/class.Engine.php");
include_once(PATH_TO_ROOT."webcati/_class/class.SurveySession.php");
include_once(PATH_TO_ROOT."_class/createQuestion/Question.php");
include_once(PATH_TO_ROOT."webcati/_class/class.Display.php");
include(PATH_TO_ROOT.'_config/dbConfig.php');
include_once(PATH_TO_ROOT.'vendor/autoload.php');



class QuestionToJsonConverterService
{
    protected $questions = null;

    public function __construct($questions)
    {
        $this->questions = $questions;
    }

    private function getQuestionContext()
    {
        $questionsContext = [];
        foreach($this->questions as $question){
            $questionsContext[] = [
                'type'         => $question->tip_sql,
                'questionText' => $question->vpr_sql,
                'instruction'  => $question->nav_sql,
                'leaveText'    => $question->getLeaveText(),
                'answers'      => $question->getAnswersArray(),
            ];
        }
        return $questionsContext;
    }

    public function toJson()
    {
        $questionData = $this->getQuestionContext();
        return json_encode($questionData);
    }
}
$action = $_POST['action'] === null?$_GET['action']:$_POST['action'];

if($action === 'getProjects') {
    $sql = "SELECT p.id, p.proj_name, wi.loginSID, p.end_date
                FROM " . DB_WARPIT_WEBCATI_BASE . "._Projects as p
                LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._www_ids as wi
                ON p.id = wi.id_project AND wi.user_type = 3";
    $res = $db->SQLexecute($sql);

    $projects = [];
    while ($row = $db->fetchAssoc($res)) {
        $countSql = "SELECT count(*) as n 
                      FROM " . DB_WARPIT_WEBCATI_BASE ."." . $row['proj_name'] . "_structure 
                      WHERE status = 1 AND status_rec = 1";
        $countRes = $db->SQLexecute($countSql);
        $countZad = $db->fetchAssoc($countRes);

        $row['n'] = $countZad['n'];

        $countSql = "SELECT count(*) as questionsCount 
                      FROM " . DB_WARPIT_WEBCATI ."." . $row['proj_name'] . " 
                      WHERE q_pos > 0";
        $countRes = $db->SQLexecute($countSql);
        $countZad = $db->fetchAssoc($countRes);

        $row['questionsCount'] = $countZad['questionsCount'];

        $projects[] = $row;
    }

    print json_encode($projects);
    exit;
} else if ($action === 'getAllQuestions') {
    $projectId   = intval($_GET['projectId']);
    $projectName = getProjectName($projectId);

    if($projectName === null){
        http_response_code(404);
        exit;
    }

    $selectQuestionsSql = "SELECT id FROM " .DB_WARPIT_WEBCATI . "." .$projectName . " WHERE q_pos > 0";
    $selectQuestionsRes = $db->SQLexecute($selectQuestionsSql);

    $questionsArray = [];
    while($questionRow = $db->fetchAssoc($selectQuestionsRes)) {
        $question = Question::createQuestionFromTable($db,$projectName,$questionRow['id']);
        $question->display = new Display($db, null);
        $questionsArray[] = $question;
    }
    $converterService = new QuestionToJsonConverterService($questionsArray);

    print $converterService->toJson();
    exit;
} else if ($action === 'saveAllQuestions') {
    $projectId   = intval($_POST['projectId']);
    $projectName = getProjectName($projectId);

    if($projectName === null){
        http_response_code(404);
        exit;
    }

    $structureTable = "{$projectName}_structure";
    $answers     = json_decode($_POST['answers'], true);

    $db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
    $fields = array_column($db->describe($structureTable), 'field');

    foreach($answers as $field => $answerValue){
        if(in_array($field, $fields) === false){
            http_response_code(400);
            print json_encode(['success' => false, 'msg' => 'Input parameters malformd']);
            exit;
        }

        $insertParts[] = "$field = '$answerValue'";
    }

    $insertParts[] = 'status = 1, status_rec = 1, t_start = UNIX_TIMESTAMP(), t_stop = UNIX_TIMESTAMP()';

    if(count($insertParts) > 1){
        $insertDataSql = "INSERT INTO {$structureTable} SET " . implode(',', $insertParts);
        $db->SQLexecute($insertDataSql);
    }
    exit;

}


$sessionId = $_POST['sessionId']=== null?$_GET['sessionId']:$_POST['sessionId'];
$answers = json_decode($_POST['answers'], true);
$loginSID  = $_GET['loginSID'];

$WebSession    = new SurveySession($db,$loginSID,null,null, $sessionId);
$_SESSION['detectedDevice'] = 2;
$questionnaire = new Engine($db,$WebSession);

if($action === 'getQuestion'){
    $questionId = $questionnaire->searchingNextQuestion()[0]['id'];
    $question = Question::createQuestionFromTable($db,$_SESSION['projname'],$questionId);
    $question->display =  new Display($db,$questionnaire);

    $convereterService = new QuestionToJsonConverterService([$question]);
    print json_encode([
        'sessionId' => session_id(),
        'question'  => $convereterService->toJson()
    ]);
} else if($action === 'saveQuestion'){
    $questionnaire->SaveQuestions($answers);
    print json_encode(['success' => true]);
}else {
    print json_encode(['success' => false, 'msg' => "Unknown action!"]);
}
