<?php

use Phinx\Migration\AbstractMigration;

class AddSampleLinkTableToWup extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $tableName = DB_WARPIT_USERSPOOL . ".`_samples_link`";
        $this->query("CREATE TABLE $tableName (
            	`id_sample` INT(11) NOT NULL,
            	`id` INT(11) NOT NULL DEFAULT '0',
            	UNIQUE INDEX `id_sample_id` (`id_sample`, `id`)
            )
            COLLATE='utf8_general_ci'
            ENGINE=InnoDB;"
        );
    }
}
