<?php

use Phinx\Migration\AbstractMigration;

class ThermoScalePluginTables extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $this->query("CREATE TABLE " . DB_WARPIT_WEBCATI_BASE .".`_plugin_thermoscale` (
                        	`id` INT(11) NOT NULL AUTO_INCREMENT,
                        	`id_project` INT(11) NOT NULL,
                        	`id_question` INT(11) NOT NULL,
                        	`answers_font_color` VARCHAR(10) NOT NULL DEFAULT '#333' COLLATE 'utf8_unicode_ci',
                        	`answers_font_family` VARCHAR(100) NOT NULL DEFAULT 'Arial, sans-serif, Verdana, Geneva, Arial, Helvetica' COLLATE 'utf8_unicode_ci',
                        	`answers_font_size` VARCHAR(10) NOT NULL DEFAULT '1.2em' COLLATE 'utf8_unicode_ci',
                        	`color` VARCHAR(255) NOT NULL DEFAULT '#ff0000,#d82600,#9f6000,#60a000,#27d900,#27D946,#27D988,#27D9C6,#27C2D9,#279BFF' COLLATE 'utf8_unicode_ci',
                        	`high_score_text` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
                        	`low_score_text` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
                        	`labels_font_color` VARCHAR(10) NOT NULL DEFAULT '#333' COLLATE 'utf8_unicode_ci',
                        	`labels_font_family` VARCHAR(100) NOT NULL DEFAULT 'Arial, sans-serif, Verdana, Geneva, Arial, Helvetica' COLLATE 'utf8_unicode_ci',
                        	`labels_font_size` VARCHAR(10) NOT NULL DEFAULT '1.2em' COLLATE 'utf8_unicode_ci',
                        	`deleted` TINYINT(1) NOT NULL DEFAULT '0',
                        	PRIMARY KEY (`id`),
                        	UNIQUE INDEX `id_project` (`id_project`, `id_question`)
                        )
                        COLLATE='utf8_unicode_ci'
                        ENGINE=MyISAM
                        ROW_FORMAT=DYNAMIC
                        AUTO_INCREMENT=4
                        ;
                    ");
    }
}
