<?php

use Phinx\Migration\AbstractMigration;

class AddPortalFieldsToInterviewer extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $newFields = [
            [
                'name'    => 'password',
                'dbType'  => 'VARCHAR(255)',
                'type'    => '0',
                'default' => 'null'
            ],
            [
                'name'    => 'active',
                'dbType'  => 'TINYINT',
                'type'    => '5',
                'default' => 'null'
            ],
            [
                'name'    => 'created',
                'dbType'  => 'DATE',
                'type'    => '8',
                'default' => 'null'
            ],
            [
                'name'    => 'phoneNumber',
                'dbType'  => 'VARCHAR(50)',
                'type'    => '2',
                'default' => 'null'
            ],
            [
                'name'    => 'name',
                'dbType'  => 'VARCHAR(128)',
                'type'    => '1',
                'default' => 'null'
            ],
            [
                'name'    => 'surname',
                'dbType'  => 'VARCHAR(128)',
                'type'    => '1',
                'default' => 'null'
            ],
            [
                'name'    => 'address',
                'dbType'  => 'VARCHAR(255)',
                'type'    => '0',
                'default' => 'null'
            ],
            [
                'name'    => 'postal_code',
                'dbType'  => 'VARCHAR(80)',
                'type'    => '1',
                'default' => 'null'
            ],
            [
                'name'    => 'city',
                'dbType'  => 'VARCHAR(60)',
                'type'    => '1',
                'default' => 'null'
            ]
        ];

        $tableInterviewer           = DB_WARPIT_USERSPOOL . "._Interviewer";
        $tableInterviewerStructure  = DB_WARPIT_USERSPOOL . "._InterviewerStructure";
        $tableInterviewerFieldOrder = DB_WARPIT_USERSPOOL . "._InterviewerFieldOrder";

        $sqlMaxOrderBy = "SELECT MAX(`orderBy`) as maxOrderBy FROM $tableInterviewerStructure";
        $maxOrderBy = $this->fetchRow($sqlMaxOrderBy);
        $maxOrderBy = intval($maxOrderBy['maxOrderBy']) + 1;

        foreach($newFields as $field){
            $sql = "SELECT id FROM $tableInterviewerStructure WHERE field_name = '" . $field['name'] . "' LIMIT 1";
            $row = $this->fetchRow($sql);
            if($row != null){
                continue;
            }

            $sqls = [];
            $sqls[] = "ALTER TABLE $tableInterviewer ADD `" . $field['name'] ."` " . $field['dbType'];

            $data = [
                0,
                $maxOrderBy,
                "'" . $field['name'] . "'",
                "'" . $field['name'] . "'",
                $field['type'],
                true
            ];
            $sqls[] = "INSERT INTO $tableInterviewerStructure (id_sup,orderBy,field_name,field_text,data_type,is_leaf) VALUES (" . implode(',', $data) . ")";
            foreach ($sqls as $sql) {
                $this->execute($sql);
            }

            $lastId = $this->getAdapter()->getConnection()->lastInsertId();
            $sql = "INSERT INTO $tableInterviewerFieldOrder (user_id,field_id,orderBy,is_hidden) VALUES (0,$lastId,$maxOrderBy,0) ";
            $this->execute($sql);

            $maxOrderBy++;
         }
     }
}
