<?php

class StepFactory
{
    private static $versions;

    private static $clientStatus;

    private static $projects;


    public static function setVersions(\DataContainers\CurrentVersion $versions)
    {
        StepFactory::$versions = $versions;
    }

    public static function setClientStatus(\DataContainers\ClientUpdateStatus $clientStatus)
    {
        StepFactory::$clientStatus = $clientStatus;
    }

    public static function setProjects(\DataContainers\CurrentProject $projects)
    {
        StepFactory::$projects = $projects;
    }



    public static function createStep($name, $params = null)
    {
      $args = func_get_args();
      $object = null;
      switch(func_num_args())
      {
          case 2: $object = new $name($args[1]); break;
          case 3: $object = new $name($args[1], $args[2]); break;
          case 4: $object = new $name($args[1], $args[2], $args[3]); break;
          default: $object = new $name(); break;
      }

      $object->setVersions(StepFactory::$versions);
      $object->setClientStatus(StepFactory::$clientStatus);
      $object->setProjectsList(StepFactory::$projects);

      return $object;
    }
}
