<?php

namespace DataContainers;

use \db;

class CurrentVersion
{
    	private static $instance;

      private $versionsToDownload = array();

      private $currentVersion;

      private $loaded = false;

      private $updated = array();

      private $first;

      private $last;

      public function __construct(db $db)
      {
          $this->db = $db;
      }

      public function setVersions($versions)
      {
          $this->versionsToDownload = $versions;

          $this->first = array_shift($versions);
          $this->first = $this->first['version'];

          if(count($versions))
            $this->last = array_pop($versions);
          else
            $this->last = $this->first;

          $this->isLoaded(true);
          //$this->next();
      }

      public function saveVersion($version)
      {
        $sql = "UPDATE " . DB_WARPIT_LIVEUPDATE . "._LiveUpdateClientVersion SET current_version = '" . $version . "'";
        if(!$this->db->SQLexecute($sql)) return false;
      }

      public function getVersion()
      {
          return $this->db->get("_LiveUpdateClientVersion", 1, "current_version", DB_WARPIT_LIVEUPDATE);
      }

      public function next()
      {

          if($this->currentVersion)
          {
                $this->updated[] = $this->currentVersion;
          }

          $this->currentVersion = array_shift($this->versionsToDownload);


          return $this->current();
      }

      public function current($property = null)
      {
          if($this->currentVersion)
          {
              if(is_null($property))
                return $this->currentVersion;
              else
                return $this->currentVersion[$property];
          }

          return false;
      }

      public function startVersion()
      {
          return $this->first;
      }

      public function endVersion()
      {
        return $this->last;
      }

      public function isMajor()
      {
          return $this->currentVersion('major');
      }

      public function done()
      {
        return $this->updated;
      }

      public function getVersionNumber()
      {
          return $this->current('version');
      }

      public function isLoaded($value = null)
      {
          if(!is_null($value)) $this->loaded = $value;

            return $this->loaded;
      }

      public function hasNext()
      {
        //var_dump($this->isLoaded(), $this->next());
          return $this->isLoaded() && $this->next();
      }

}
