#!/usr/bin/env bash
SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
WARPIT_DIR=$( realpath -e "$SCRIPT_DIR"/../../../warpit )
timestamp=$(date +"%Y%m%d%H%M%S")

pushd "$SCRIPT_DIR" &> /dev/null || exit 1
shopt -s globstar

echo " +---------------------------------+"
echo " | Installing IFES Warp-It scripts |"
echo " +---------------------------------+"

for entry in "$SCRIPT_DIR"/**/*.php
do
  localPath=$(realpath -s --relative-to=. "$entry")
  fileName=$(basename "$entry")
  if [[ $fileName = __* ]]; then
    continue
  fi

  warpitPath="$WARPIT_DIR"/"$localPath"
  echo -n  "  ""$localPath"" -> "
  if [ ! -L "$warpitPath" ]; then
    # backup current script, if it's not a symlink
    mv "$warpitPath" "$warpitPath".original."$timestamp"
  else
    # delete existing symlink
    rm "$warpitPath"
  fi

  # create symlink
  ln -s "$SCRIPT_DIR"/"$localPath" "$warpitPath"
  echo "$warpitPath"
done


popd &> /dev/null || exit 1