<?php

namespace ifes;

// TODO use everywhere
abstract class FileChecks
{
    public static function warnIfFileNotExists($file, $context = null)
    {
        self::checkIfFileExists(Log::WARN, $file, $context);
    }

    public static function errorIfFileNotExists($file, $context = null)
    {
        self::checkIfFileExists(Log::ERROR, $file, $context);
    }

    public static function infoIfFileNotExists($file, $context = null)
    {
        self::checkIfFileExists(Log::INFO, $file, $context);
    }

    public static function debugIfFileNotExists($file, $context = null)
    {
        self::checkIfFileExists(Log::DEBUG, $file, $context);
    }

    private static function checkIfFileExists($logLevel, $file, $context = null) {
        //TODO DEV-Mode only!
        if (!file_exists($file)) {
            $msg = "Die Datei '$file' existiert nicht.";
            Log::addEntry($logLevel, $msg, $context);
        }
    }
}