<?php

/** @noinspection PhpUnhandledExceptionInspection */
/** @noinspection PhpDocMissingThrowsInspection */

namespace ifes;

use ProjectInfo;

abstract class VarManager
{
    private static $getCache = array();
    private static $setCache = array();

    /**
     * @param string|string[] $vars comma separated string of column names or array containing column names
     * @param bool $forceLoadFromDb disable cache and force reload from database
     * @return mixed|array<string,string> value of single column or array, if $vars contains multiple columns
     * TODO discuss return value with Alex (reset or not reset???)
     */
    public static function getVar($vars, $forceLoadFromDb = false)
    {
        if (is_string($vars)) {
            $vars = explode(',', $vars);
        }
        if ($forceLoadFromDb) self::flushCache();

        $retVal = array();
        $varsToLoad = array();

        foreach (array_keys($vars) as $key) {
            $var = trim($vars[$key]);
            if (array_key_exists($var, self::$getCache)) {
                $retVal[$var] = self::$getCache[$var];
            } else {
                $varsToLoad[] = $var;
                $retVal[$var] = null; // add to retVal to preserve order of columns, value will be set later
            }
        }

        if (count($varsToLoad) > 0) {
            $vars = implode(',', $varsToLoad);
            global $db;
            $db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
            $sql = "SELECT $vars FROM " . ProjectInfo::structureTableName() . " WHERE id = " . $_SESSION['id_record'];
            $res = $db->SQLexecute($sql);
            $row = $db->fetchAssoc($res);

            foreach ($row as $var => $value) {
                self::$getCache[$var] = $value;
                $retVal[$var] = $value;
            }
        }
        return count($retVal) == 1 ? $retVal[0] : $retVal;
    }

    /**
     * @param string $var column name
     * @param mixed $value new value
     * @param bool $forceLoadFromDb disable cache and immediately flush changes
     * @return void
     */
    public static function setVar($var, $value, $forceLoadFromDb = false) {
        self::saveVar([$var => $value], $forceLoadFromDb);
    }

    /**
     * @param string|array $vars coma separated string (ie. q1=2,q2=6) or associative array (ie. ['column' => value])
     * @param bool $forceSaveToDb disable cache and immediately flush changes
     * @return void
     */
    public static function saveVar($vars, $forceSaveToDb = false)
    {
        if (is_string($vars)) {
            $vars = explode(',', $vars);
            $parsedVars = array();
            foreach (explode(',', $vars) as $expr) {
                foreach (explode('=', $expr) as $var => $value) {
                    $parsedVars[$var] = trim(trim($value), "'\"");
                }
            }
            $vars = $parsedVars;
        }

        foreach ($vars as $var => $value) {
            self::$setCache[$var] = $value;
            self::$getCache[$var] = $value;
        }

        if ($forceSaveToDb) self::flushCache();
    }

    /**
     * @return void
     */
    public static function flushCache() {

        if (count(self::$setCache) > 0) {
            global $db;
            $db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
            $vars = array();
            foreach (self::$setCache as $var => $value) {
                if (!is_numeric($value)) $value = "'$value'";
                $vars[] = "$var=$value";
            }
            $vars = implode(',', $vars);

            $sql = "UPDATE " . ProjectInfo::structureTableName() . " SET $vars WHERE id = " . $_SESSION['id_record'];
            $db->SQLexecute($sql);
        }

        self::$getCache = array();
        self::$setCache = array();
    }
}