<?php

namespace ifes;

class ProjectConfigStorage implements IStorage, IStorageArea
{

    const STORAGE_KEY = '__CONFIG__';

    private static $instance;

    private $data;
    private $modified = false;
    private $persistChanges = false;

    private function __construct() {
        PersistentSessionStorage::registerStorageArea($this);
        $this->loadData();
    }

    private function loadData() {
        if (PersistentSessionStorage::storageKeyExists(self::STORAGE_KEY)) {
            $this->data = PersistentSessionStorage::getStorage(self::STORAGE_KEY);
        } else {
            $this->data = array();
        }
        $this->modified = false;
        $this->persistChanges = false;
    }

    public static function getInstance() {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function get($varName)
    {
        return $this->exists($varName) ? $this->data[$varName] : null;
    }

    function set($varName, $varValue)
    {
        $this->data[$varName] = $varValue;
        $this->modified = true;
    }

    function remove($varName)
    {
        if($this->exists($varName)) {
            unset($this->data[$varName]);
            $this->modified = true;
        }
    }

    function exists($varName)
    {
        return array_key_exists($varName, $this->data);
    }

    function hasChanges()
    {
        return $this->modified && $this->persistChanges;
    }

    function getData()
    {
        return $this->data;
    }

    function getStorageKey()
    {
        return self::STORAGE_KEY;
    }

    function reloadData()
    {
        $this->loadData();
    }

    function forceSaveChanges() {
        $this->persistChanges = true;
        $this->modified = true;
        PersistentSessionStorage::saveChanges();
    }
}