<?php

namespace ifes;

use ProjectInfo;

class PersistentSessionStorage implements IStorage
{
    const SESSION_STORAGE_KEY = '__PERSISTENT_SESSION_STORAGE__';
    const DB_COLUMN_NAME = 'fbVars';

    private static $instance;
    private static $projectId;
    private static $storageAreas = array();
    private $data;

    public static function registerStorageArea(IStorageArea $storage)
    {
        self::$storageAreas[$storage->getStorageKey()] = $storage;
    }

    public static function saveChanges()
    {
        $state = array();
        $saveToDb = false;

        /* @var $storage IStorageArea */
        foreach (self::$storageAreas as $storageKey => $storage) {
            if ($storage->hasChanges()) {
                $state[$storageKey] = $storage->getData();
                $saveToDb = true;
            }
        }

        foreach(self::getInstance()->data as $storageKey => $storageData) {
            if (!array_key_exists($storageKey, $state)) {
                $state[$storageKey] = $storageData;
            }
        }

        $_SESSION[self::SESSION_STORAGE_KEY] = $state;

        if ($saveToDb) {
            VarManager::setVar(self::DB_COLUMN_NAME, serialize($state));
        }

        self::getInstance()->data = $state;

        /* @var $storage IStorageArea */
        foreach (self::$storageAreas as $storage) {
            $storage->reloadData();
        }
    }

    private static function getInstance()
    {
        if (!isset(self::$instance) || self::$projectId !== ProjectInfo::id()) {
            self::$instance = new self();
            self::$projectId = ProjectInfo::id();

            foreach (self::$storageAreas as $storage) {
                $storage->reloadData();
            }
        }
        return self::$instance;
    }

    public static function getStorage($storageKey) {
        return self::getInstance()->get($storageKey);
    }

    public static function storageKeyExists($storageKey) {
        return self::getInstance()->exists($storageKey);
    }

    private function __construct()
    {
        if (!is_array($_SESSION[self::SESSION_STORAGE_KEY])) {
            $data = getVar(self::DB_COLUMN_NAME);
            if ($data) {
                $_SESSION[self::SESSION_STORAGE_KEY] = unserialize($data);
            } else {
                $_SESSION[self::SESSION_STORAGE_KEY] = array();
            }
        }

        $this->data = $_SESSION[self::SESSION_STORAGE_KEY];
    }

    public function get($varName)
    {
        if (!array_key_exists($varName, $this->data)) {
            $this->data[$varName] = array();
        }
        return $this->data[$varName];
    }

    public function set($varName, $varValue)
    {
        $this->data[$varName] = $varValue;
    }

    public function remove($varName)
    {
        if ($this->exists($varName)) unset($this->data[$varName]);
    }

    public function exists($varName)
    {
        return array_key_exists($varName, $this->data);
    }
}