<?php

namespace ifes;

class LogEntry {
    /* @var $message string */
    private $message;
    /* @var $level string */
    private $level;
    /* @var $context mixed */
    private $context;

    public function __construct($message, $level, $context) {
        $this->message = $message;
        $this->level = $level;
        $this->context = $context;
    }

    public function getMessage()
    {
        return $this->message;
    }

    public function getLevel()
    {
        return $this->level;
    }

    public function getContext()
    {
        return $this->context;
    }
}

// TODO implement logging
abstract class Log
{
    const WARN = 'WARN';
    const INFO = 'INFO';
    const DEBUG = 'DEBUG';
    const ERROR = 'ERROR';

    private static $entries = array();

    public static function addEntry($level, $message, $context = null) {
        $entry = new LogEntry($level, $message, $context);
        self::$entries[] = $entry;
    }

    public static function info($message, $context = null) {
        self::addEntry(self::INFO, $message, $context);
    }

    public static function warn($message, $context = null) {
        self::addEntry(self::WARN, $message, $context);
    }

    public static function debug($message, $context = null) {
        self::addEntry(self::DEBUG, $message, $context);
    }

    public static function error($message, $context = null) {
        self::addEntry(self::ERROR, $message, $context);
    }

    public static function getEntries()
    {
        return self::$entries;
    }

    public static function hasEntries() {
        return count(self::$entries) > 0;
    }

    public static function clearEntries() {
        self::$entries = array();
    }

}