<?php

namespace ifes;

class ConfigStorageArea implements IStorage
{
    private $storageKey;
    /* @var $storage IStorage */
    private $storage;

    public function __construct($storageKey, ConfigStorageArea $parent = null)
    {
        $this->storageKey = $storageKey;
        if ($parent !== null) {
            $this->storage = $parent;
        } else {
            $this->storage = ProjectConfigStorage::getInstance();
        }
    }

    function get($varName)
    {
        $values = $this->storage->get($this->storageKey);
        if (!$values || !array_key_exists($varName, $values)) return null;
        return $values[$varName];
    }

    function set($varName, $varValue)
    {
        $values = $this->storage->get($this->storageKey);

        if (!$values) $values = array();
        $values[$varName] = $varValue;

        $this->storage->set($this->storageKey, $values);
    }

    function remove($varName)
    {
        $values = $this->storage->get($this->storageKey);
        if (!$values || !array_key_exists($varName, $values)) return;
        unset($values[$varName]);
        if (count($values) == 0) {
            $this->storage->remove($this->storageKey);
        } else {
            $this->storage->set($this->storageKey, $values);
        }
    }

    function exists($varName)
    {
        $values = $this->storage->get($this->storageKey);
        if (!$values) return false;
        return array_key_exists($varName, $values);
    }
}