<?php

namespace ifes;

use PageHeader;

class HtmlPageHeader
{
    const LOGO_HTML = '<div class="navbar-logo"></div>';
    const BUTTON_HTML = '<div class="navbar-toggler"><label class="navbar-hamburger" for="navbar-hamburger-check"><input type="checkbox" id="navbar-hamburger-check"><span class="top"></span><span class="middle"></span><span class="middle"></span><span class="bottom"></span></label></div>';

    public static function render()
    {
        $vars = array(
            "header_logo" => (PageHeader::isLogoVisible() ? self::LOGO_HTML : ''),
            "header_title" => PageHeader::getTitle(),
            "header_menu" => self::getMenuEntriesHtml(),
            "header_menu_button" => (PageHeader::isMenuVisible() ? self::BUTTON_HTML : ''),
            "year" => date("Y")
        );
        return self::replaceVars(self::getTemplate(), $vars);
    }

    private static function replaceVars($template, $vars)
    {
        $tVars = array();
        foreach ($vars as $key => $value) {
            $tVars["[!$key!]"] = $value;
        }

        // replace variables in variables
        foreach ($tVars as $key => $value) {
            $tVars[$key] = strtr($value, $tVars);
        }

        return strtr($template, $tVars);
    }

    private static function getMenuEntriesHtml()
    {
        if (!PageHeader::isMenuVisible()) return '';
        $html = PageHeader::getMenuHtml();
        if ($html) return $html;
        $menuEntries = PageHeader::getMenuEntries();
        $html = '';
        $content = '';
        $linkCount = 0;
        if (is_array($menuEntries) && count($menuEntries) > 0) {
            $html = "<div class=\"navbar-links\">\n<ul class=\"navbar-links\">\n";
            foreach ($menuEntries as $link => $template) {
                $linkCount++;
                $id = "menu-entry-$linkCount";
                $html .= "<li class=\"navbar-link\"><a class=\"nav-link\" id=\"$id-link\" href=\"#\" onclick=\"showMenuEntry('#$id');\">$link</a></li>\n";

                $content .= "<div id=\"$id\" class=\"navbar-menu-content\">\n" . file_get_contents($template) . "\n</div>\n";
            }
            $html .= "</ul>\n</div>\n";
            $html .= "<div class=\"navbar-content\">\n";
            $html .= $content;
            $html .= "</div>\n";
        }
        return $html;
    }

    private static function getTemplate()
    {
        $template = PageHeader::getTemplate();

        if (!file_exists($template)) {
            return "<div>Header template '$template' not found!</div>";
        } else {
            return file_get_contents($template);
        }
    }
}
