<?php
const WARPIT_ROOT_DIR = PATH_TO_ROOT;

include_once WARPIT_ROOT_DIR . '_support/class.db.php';

function get_api_version()
{
    if (isset($_SESSION['IFES_API_VERSION'])) return $_SESSION['IFES_API_VERSION'];

    global $db;
    $project_id = $_SESSION['id_project'];
    $project_name = $_SESSION['proj_name'];

    if (!$project_id || !$project_name) {
        return null;
    }

    // API v1 check
    $apiV1Fn = function () use ($db, $project_id, $project_name) {
        $sql = "SELECT 1 AS enabled FROM " . DB_WARPIT_WEBCATI_BASE . "._DesignerManager dm 
                INNER JOIN " . DB_WARPIT_WEBCATI_BASE . "._DesignerTemplates dt ON dm.id_template = dt.id
                INNER JOIN " . DB_WARPIT_WEBCATI . "." . $project_name . "_script s ON s.id_question = 0 AND s.id_event = 3 and s.script like '%/*%IFES_CONFIG_START%api_version=v1%IFES_CONFIG_END%*/'
                WHERE dm.id_project = " . $project_id . " AND dm.type_device=0 AND dt.name LIKE 'IFES_responsive%' limit 1";

        $res = $db->SQLexecute($sql);
        if (!$res) return false;
        return $db->fetchAssoc($res)['enabled'] == 1;
    };

    $validateVersion = function ($version) {
        if ($version == 'v2') return true;
        return false;
    };

    $version = null;
    if ($apiV1Fn()) {
        $version = 'v1';
    } else {
        $sql = "SELECT trim(s.script) as script FROM " . DB_WARPIT_WEBCATI . "." . $project_name . "_script s 
                WHERE id_question = 0 and id_event = 1 AND trim(s.script) like '//API_VERSION=%'";

        $res = $db->SQLexecute($sql);
        if ($res) {
            $script = $db->fetchAssoc($res)['script'];
            if ($script) {
                $versionLine = trim(preg_split("/((\r?\n)|(\n?\r))/", $script)[0]);
                $version = substr($versionLine, 14);
                if (!$validateVersion($version)) {
                    echo "<h1>Ungültige API Version - bitte im 'Start of survey' Script korrigieren!</h1><p>API_VERSION=$version</p>";
                    exit;
                }
            }
        }
    }

    $_SESSION['IFES_API_VERSION'] = $version;
    return $version;
}

switch (get_api_version()) {
    case 'v1':
        require_once '../../warpit-ifes/php/api_v1.php';
        break;
    case 'v2':
        require_once '../../warpit-ifes/php/api_v2.php';
        break;
    default;
        require_once '../../warpit-ifes/php/api_default_warpit_behavior.php';
}

if (!function_exists('IfesInitialize')) {
    function IfesInitialize()
    {
    }
}
if (!function_exists('IfesFinalize')) {
    function IfesFinalize()
    {
    }
}
if (!function_exists('IfesWritePageHeader')) {
    function IfesWritePageHeader()
    {
    }
}
if (!function_exists('IfesWriteFormWrapperStartTag')) {
    function IfesWriteFormWrapperStartTag()
    {
    }
}
if (!function_exists('IfesWriteFormStartTag')) {
    function IfesWriteFormStartTag()
    {
        echo "<FORM style=\"height:100%;border: 0 none;margin:0;padding:0;width:100%; \" id='mainForm' METHOD='POST' action='" . htmlspecialchars($_SERVER['PHP_SELF']) . "'>";
    }
}
if (!function_exists('IfesWriteFormEndTag')) {
    function IfesWriteFormEndTag()
    {
        echo "</FORM>";
    }
}
if (!function_exists('IfesWriteFormWrapperEndTag')) {
    function IfesWriteFormWrapperEndTag()
    {
    }
}
if (!function_exists('Ifes_Before_StartOfSurveyScript')) {
    function Ifes_Before_StartOfSurveyScript()
    {
    }
}
if (!function_exists('Ifes_After_StartOfSurveyScript')) {
    function Ifes_After_StartOfSurveyScript()
    {
    }
}
if (!function_exists('Ifes_Before_QuestionBeforeLoadScript')) {
    function Ifes_Before_QuestionBeforeLoadScript()
    {
    }
}
if (!function_exists('Ifes_After_QuestionBeforeLoadScript')) {
    function Ifes_After_QuestionBeforeLoadScript()
    {
    }
}

if (!function_exists('IfesIncludeDefaultBodyTag')) {
    function IfesIncludeDefaultBodyTag()
    {
        return true;
    }
}

if (!function_exists('IfesIncludeEventLogger')) {
    function IfesIncludeEventLogger()
    {
        return true;
    }
}
