<?php
/** @noinspection DuplicatedCode */

const IFES_API_VERSION = 'v2';
const IFES_ROOT_DIR = '../../warpit-ifes/';


// Internal
require_once IFES_ROOT_DIR . 'php/internal/IStorage.php';
require_once IFES_ROOT_DIR . 'php/internal/IStorageArea.php';
require_once IFES_ROOT_DIR . 'php/internal/ConfigStorageArea.php';
require_once IFES_ROOT_DIR . 'php/internal/Log.php';
require_once IFES_ROOT_DIR . 'php/internal/PersistentSessionStorage.php';
require_once IFES_ROOT_DIR . 'php/internal/ProjectConfigStorage.php';
require_once IFES_ROOT_DIR . 'php/internal/SessionVariableStorage.php';
require_once IFES_ROOT_DIR . 'php/internal/VarManager.php';

// Checks
require_once IFES_ROOT_DIR . 'php/internal/checks/FileChecks.php';

// Info
require_once IFES_ROOT_DIR . 'php/api/info/ProjectInfo.php';
require_once IFES_ROOT_DIR . 'php/api/info/SurveyInfo.php';
require_once IFES_ROOT_DIR . 'php/api/info/ThisQuestion.php';

// Config
require_once IFES_ROOT_DIR . 'php/api/config/Appointment.php';
require_once IFES_ROOT_DIR . 'php/api/config/BackButton.php';
require_once IFES_ROOT_DIR . 'php/api/config/CSS.php';
require_once IFES_ROOT_DIR . 'php/api/config/HangupButton.php';
require_once IFES_ROOT_DIR . 'php/api/config/JS.php';
require_once IFES_ROOT_DIR . 'php/api/config/NextButton.php';
require_once IFES_ROOT_DIR . 'php/api/config/PageHeader.php';
require_once IFES_ROOT_DIR . 'php/api/config/Progressbar.php';
require_once IFES_ROOT_DIR . 'php/api/config/TestInfo.php';
require_once IFES_ROOT_DIR . 'php/api/config/TStatus.php';

// Design
require_once IFES_ROOT_DIR . 'php/design/DesignConstants.php';
require_once IFES_ROOT_DIR . 'php/design/HtmlPageHeader.php';
require_once IFES_ROOT_DIR . 'php/design/IfesDesignV2.php';

// Functions
require_once IFES_ROOT_DIR . 'php/api/functions/session_vars.php';
require_once IFES_ROOT_DIR . 'php/api/functions/dev_utils.php';


use ifes\DesignConstants;
use ifes\IfesDesignV2;
use ifes\PersistentSessionStorage;
use ifes\ProjectConfigStorage;

$ifesDesign = new IfesDesignV2();

function IfesInitialize()
{
    global $ifesDesign;
    $ifesDesign->executePHPIncludeScript();
}

function Ifes_Before_StartOfSurveyScript()
{
    CSS::setFiles([IFES_ROOT_DIR . 'css/styles.css']);
    JS::setHeadFiles([IFES_ROOT_DIR . 'js/ifes.js']);

    TestInfo::enable();
    TestInfo::setMessage("Test Interview");

    if (ProjectInfo::hideBackButton()) BackButton::hide(); else BackButton::show();
    BackButton::setText(DesignConstants::ICON_SVG_BACK . "Zurück");
    BackButton::show();
    NextButton::setText("Weiter" . DesignConstants::ICON_SVG_FORWARD);
    NextButton::show();
    HangupButton::show();
    HangupButton::setText("Auflegen");

    PageHeader::enable();
    PageHeader::showLogo();
    PageHeader::setTitle(ProjectInfo::browserTitle());
    PageHeader::setTemplate(IFES_ROOT_DIR . 'templates/header.html');
    PageHeader::showMenu();
    PageHeader::setMenuEntries([
        'Hilfe' => IFES_ROOT_DIR . 'templates/default-menu/help.html',
        'Impressum' => IFES_ROOT_DIR . 'templates/default-menu/impressum.html'
    ]);

    Progressbar::show();
    Progressbar::showPercentage();
    Progressbar::setTemplate('<div class="ifes-progressbar"><div><div>[!progresstext!]</div><div style="width:[!progress!]"><div>[!progresstext!]</div></div></div></div>');
}

function Ifes_After_StartOfSurveyScript()
{
    ProjectConfigStorage::getInstance()->forceSaveChanges();
}

function IfesHeadIncludes()
{
    global $ifesDesign;
    include IFES_ROOT_DIR . 'php/design/includes/head_includes.php';

    $ifesDesign->writeCssLinks();
    $ifesDesign->writeJsHeadScripts();
    $ifesDesign->writeProjectCss();
}

function IfesRunQuestionScripts()
{
    global $nextQuestion;
    global $ifesDesign;
    // TODO - set question variables
    $questionId = $nextQuestion[0]['id'];
    $ifesDesign->executeScriptsForQuestion($questionId);
}

function IfesWritePageHeader()
{
    global $ifesDesign;
    $ifesDesign->writePageHeader();
}

function IfesWriteFormWrapperStartTag()
{
    global $ifesDesign;
    $ifesDesign->writeFormWrapperStartTag();
}

function IfesWriteFormStartTag() {
    global $ifesDesign;
    $ifesDesign->writeFormStartTag();
}

function IfesWriteFormEndTag()
{
    global $ifesDesign;
    $ifesDesign->writeFormEndTag();
}

function IfesWriteFormWrapperEndTag()
{
    global $ifesDesign;
    $ifesDesign->writeFormWrapperEndTag();
}

function IfesProcessXmlTemplate(SimpleXMLElement $xml)
{
    global $ifesDesign;
    global $display;
    $html = "";

    foreach ($xml->children() as $child) {
        $html .= $ifesDesign->processXmlTemplate($display, $child, 0, false);
    }

    return $html;
}

function IfesWriteScriptOutput()
{
    global $ifesDesign;
    $ifesDesign->writeQuestionScriptOutput();
}

function IfesFinalize()
{
    global $ifesDesign;
    $ifesDesign->writeJsBottomScripts();

    PersistentSessionStorage::saveChanges();
}

function IfesIncludeDefaultBodyTag()
{
    return false;
}

function IfesIncludeEventLogger()
{
    //TODO implement or remove
    return true;
}
