<?php
const IFES_API_VERSION = 'v1';
const IFES_ROOT_DIR = '../../ifes-design/';
const IFES_PROJECT_ROOT_DIR = WARPIT_ROOT_DIR . '../webIfesProjects/ProjFiles/';
require_once IFES_ROOT_DIR . 'php/IfesDesignV1.php';

$ifesScriptOutput = "";

function IfesInitialize()
{
    global $db;
    global $questionnaire;
    global $ifesDesign;
    global $ifes;

    $ifesDesign = new IfesDesignV1($db, $questionnaire);
    $ifes = $ifesDesign->getConfig();
}

function IfesHeadIncludes()
{
    /* @var $ifesDesign IfesDesignV1 */
    global $ifesDesign;
    if ($ifesDesign && $ifesDesign->enabled()) {
        include IFES_ROOT_DIR . 'php/includes/head_includes.php';
        $ifesDesign->writeCssLinks();
        $ifesDesign->writeScriptTags();
    } else {
        include PATH_TO_ROOT . 'survey/javascript/head_includes_js.php';
    }
}

function IfesRunQuestionScripts()
{
    global $db;
    global $nextQuestion;

    /* @var $ifesDesign IfesDesignV1 */
    global $ifesDesign;
    global $ifesScriptOutput;

    ob_start();

    $beforeDisplayScript = $db->get(DB_WARPIT_WEBCATI . " ." . $_SESSION['proj_name'] . "_script", "id_question=" . $nextQuestion[0]['id'] . " AND id_event = 2 ", "script");
    $beforeEveryQuestionScript = $db->get(DB_WARPIT_WEBCATI . " ." . $_SESSION['proj_name'] . "_script", "id_question = 0 AND id_event = 3 ", "script");

    if ($ifesDesign && $ifesDesign->enabled()) {
        $ifesDesign->setQuestion($nextQuestion[0]);
        // reversed order of script execution to allow question specific overrides
        // 1: beforeEveryQuestion
        // 2: beforeDisplay
        if (is_array($beforeEveryQuestionScript)) {
            $source = $beforeEveryQuestionScript[0];
            eval($source);
        }

        if (is_array($beforeDisplayScript)) {
            $source = $beforeDisplayScript[0];
            eval($source);
        }
    } else {
        // original order of script execution
        // 1: beforeDisplay
        // 2: beforeEveryQuestion
        if (is_array($beforeDisplayScript)) {
            $source = $beforeDisplayScript[0];
            eval($source);
        }

        if (is_array($beforeEveryQuestionScript)) {
            $source = $beforeEveryQuestionScript[0];
            eval($source);
        }
    }
    $ifesScriptOutput = ob_get_contents();
    ob_end_clean();

    $ifesDesign->initVariables();
}

function IfesWritePageHeader()
{
    /* @var $ifesDesign IfesDesignV1 */
    global $ifesDesign;
    $ifesDesign->writeHeader();
}

function IfesWriteFormWrapperStartTag()
{
    /* @var $ifesDesign IfesDesignV1 */
    global $ifesDesign;
    $ifesDesign->writeWrapperStartTag();
}

function IfesWriteFormWrapperEndTag() {
    /* @var $ifesDesign IfesDesignV1 */
    global $ifesDesign;
    $ifesDesign->writeWrapperEndTag();
}

function IfesWriteScriptOutput() {
    global $ifesScriptOutput;
    echo $ifesScriptOutput;
}

function IfesProcessXmlTemplate(SimpleXMLElement $xml) {
    /* @var $ifesDesign IfesDesignV1 */
    global $ifesDesign;
    global $display;
    $html = "";

    foreach ($xml->children() as $child) {
        $html .= $ifesDesign->processXmlTemplate($display, $child, 0, false);
    }

    return $html;
}
