<?php

abstract class ProjectInfo
{
    public static function id()
    {
        return $_SESSION['id_project'];
    }

    public static function name()
    {
        return $_SESSION['proj_name'];
    }

    public static function browserTitle()
    {
        return self::getProperty('browser_title');
    }

    public static function hideBackButton()
    {
        return (bool)self::getProperty('hide_back_button');
    }

    public static function submitOnEnter() {
        return (bool)self::getProperty('submit_on_enter');
    }

    public static function getProperty($propertyName) {
        return getProjectProperty(self::id(), $propertyName);
    }

    public static function projectTableName($dbQualified)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI, self::name(), $dbQualified);
    }

    public static function treeTableName($dbQualified = true)
    {
        return self::projectTableName($dbQualified) . '_tree';
    }

    public static function languageTableName($dbQualified = true)
    {
        return self::projectTableName($dbQualified) . '_language';
    }

    public static function scriptTableName($dbQualified = true)
    {
        return self::projectTableName($dbQualified) . '_script';
    }

    public static function structureTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '_structure';
    }

    public static function engineLogTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___EngineLog';
    }

    public static function telIndexTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___telIndex';
    }

    public static function telLogTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___telLog';
    }

    public static function quotaCalcTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___quotaCalc';
    }

    public static function quotaLimitsTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___quotaLimits';
    }

    public static function quotaLimitsDefaultTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___quotaLimitsDefault';
    }

    public static function quotaLockTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___quotaLock';
    }

    public static function sampleTableName($dbQualified = true)
    {
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, ProjectInfo::name(), $dbQualified) . '___sample';
    }

    public static function catiSampleTableName($dbQualified = true)
    {
        static $tableName;
        if (!isset($tableName)) {
            global $db;
            $tableId = self::getProperty('id_telname');
            if ($tableId) {
                $tableName = 'tel___' . $db->get('_TelephoneTables', $tableId, 'name', DB_WARPIT_WEBCATI_BASE);
            } else {
                $tableName = false;
            }
        }
        if ($tableName === false) return '';
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, $tableName, $dbQualified);
    }

    public static function capiSampleTableName($dbQualified = true)
    {
        static $tableName;
        if (!isset($tableName)) {
            global $db;
            $tableId = self::getProperty('id_capiTable');
            if ($tableId) {
                $tableName = 'tel___' . $db->get('_CapiTables', $tableId, 'name', DB_WARPIT_WEBCATI_BASE);
            } else {
                $tableName = false;
            }
        }
        if ($tableName === false) return '';
        return self::formatDatabaseTableName(DB_WARPIT_WEBCATI_BASE, $tableName, $dbQualified);
    }

    private static function formatDatabaseTableName($databaseName, $tableName, $dbQualified)
    {
        if (!$dbQualified) return $tableName;
        return $databaseName . '.' . $tableName;
    }
}