<?php

use ifes\ConfigStorageArea;

abstract class TestInfo
{
    const ENABLED_KEY = "enabled";
    const MESSAGE_KEY = "message";

    /* @var $storage ConfigStorageArea */
    private static $storage;

    private static function init()
    {
        if (!self::$storage) {
            self::$storage = new ConfigStorageArea(get_called_class());
        }
    }

    public static function enable()
    {
       self::init();
       self::$storage->set(self::ENABLED_KEY, true);
    }

    public static function disable()
    {
        self::init();
        self::$storage->set(self::ENABLED_KEY, false);
    }

    public static function isEnabled()
    {
        self::init();
        return (bool)self::$storage->get(self::ENABLED_KEY);
    }

    public static function setMessage($message)
    {
        self::init();
        self::$storage->set(self::MESSAGE_KEY, $message);
    }

    public static function getMessage()
    {
        self::init();
        return self::$storage->get(self::MESSAGE_KEY);
    }
}