<?php

use ifes\ConfigStorageArea;
//TODO Defaults
abstract class Progressbar
{

    const VISIBLE_KEY = "visible";
    const PERCENTAGE_KEY = "percentage";
    const STEPS = "steps";
    const TEMPLATE_KEY = "template";


    /* @var $storage ConfigStorageArea */
    private static $storage;

    private static function init()
    {
        if (!self::$storage) {
            self::$storage = new ConfigStorageArea(get_called_class());
        }
    }

    public static function show()
    {
        self::init();
        self::$storage->set(self::VISIBLE_KEY, true);
    }

    public static function hide()
    {
        self::init();
        self::$storage->set(self::VISIBLE_KEY, false);
    }

    public static function isVisible()
    {
        self::init();
        return (bool)self::$storage->get(self::VISIBLE_KEY);
    }

    public static function showPercentage()
    {
        self::init();
        self::$storage->set(self::PERCENTAGE_KEY, true);
    }

    public static function hidePercentage()
    {
        self::init();
        self::$storage->set(self::PERCENTAGE_KEY, false);
    }

    public static function isPercentageVisible()
    {
        self::init();
        return (bool)self::$storage->get(self::PERCENTAGE_KEY);
    }

    public static function setProgressSteps(array $steps)
    {
        self::init();
        self::$storage->set(self::STEPS, $steps);
    }

    public static function getProgressSteps()
    {
        self::init();
        return self::$storage->get(self::STEPS);
    }

    public static function hasProgressSteps()
    {
        self::init();
        $steps = self::$storage->get(self::STEPS);
        return is_array($steps) && count($steps) > 0;
    }

    public static function getTemplate()
    {
        self::init();
        return self::$storage->get(self::TEMPLATE_KEY);
    }

    public static function setTemplate($template)
    {
        self::init();
        self::$storage->set(self::TEMPLATE_KEY, $template);
    }
}