<?php

use ifes\ConfigStorageArea;
use ifes\FileChecks;

abstract class JS
{
    const HEAD_FILES_KEY = "head_files";
    const BOTTOM_FILES_KEY = "bottom_files";

    /* @var $storage ConfigStorageArea */
    private static $storage;

    private static function init()
    {
        if (!self::$storage) {
            self::$storage = new ConfigStorageArea(get_called_class());
        }
    }


    private static function setFiles($storageKey, $fileOrFiles) {
        self::init();

        if (!$fileOrFiles) {
            $fileOrFiles = array();
        } elseif (!is_array($fileOrFiles)) {
            $fileOrFiles = array($fileOrFiles => false);
        }

        foreach ($fileOrFiles as $file) {
            FileChecks::warnIfFileNotExists($file);
        }

        self::$storage->set($storageKey, $fileOrFiles);
    }

    private static function addFile($storageKey, $fileOrFiles)
    {
        if (!$fileOrFiles) return;

        self::init();
        $files = self::$storage->get($storageKey);

        if (!is_array($files)) {
            $files = array();
        }
        if (!is_array($fileOrFiles)) {
            $fileOrFiles = array($fileOrFiles);
        }

        foreach ($fileOrFiles as $file) {
            if (!array_key_exists($file, $files)) {
                FileChecks::warnIfFileNotExists($file);
            }
            $files[] = $file;
        }
        self::$storage->set($storageKey, $files);
    }

    private static function removeFile($storageKey, $fileOrFiles)
    {
        self::init();
        $files = self::$storage->get($storageKey);
        if (!is_array($files) || count($files) === 0) return;

        if (!is_array($fileOrFiles)) {
            $fileOrFiles = array($fileOrFiles);
        }

        $modified = false;
        foreach ($fileOrFiles as $file) {
            if (array_key_exists($file, $files)) {
                unset($files[$file]);
                $modified = true;
            }
        }

        if ($modified) {
            self::$storage->set($storageKey, $files);
        }
    }

    private static function getFiles($storageKey)
    {
        self::init();
        $files = self::$storage->get($storageKey);
        if (!is_array($files)) {
            return array();
        }

        return $files;
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function addHeadFiles($fileOrFiles)
    {
        self::addFile(self::HEAD_FILES_KEY, $fileOrFiles);
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function removeHeadFile($fileOrFiles)
    {
        self::removeFile(self::HEAD_FILES_KEY, $fileOrFiles);
    }

    /**
     * @return array
     */
    public static function getHeadFiles()
    {
        return self::getFiles(self::HEAD_FILES_KEY);
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function setHeadFiles($fileOrFiles) {
        self::setFiles(self::HEAD_FILES_KEY, $fileOrFiles);
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function addBottomFiles($fileOrFiles)
    {
        self::addFile(self::BOTTOM_FILES_KEY, $fileOrFiles);
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function removeBottomFile($fileOrFiles)
    {
        self::removeFile(self::BOTTOM_FILES_KEY, $fileOrFiles);
    }

    /**
     * @return array
     */
    public static function getBottomFiles()
    {
        return self::getFiles(self::BOTTOM_FILES_KEY);
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function setBottomFiles($fileOrFiles) {
        self::setFiles(self::BOTTOM_FILES_KEY, $fileOrFiles);
    }
}
