<?php

use ifes\ConfigStorageArea;
use ifes\FileChecks;

abstract class CSS
{
    const FILES_KEY = "files";

    /* @var $storage ConfigStorageArea */
    private static $storage;

    private static function init()
    {
        if (!self::$storage) {
            self::$storage = new ConfigStorageArea(get_called_class());
        }
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function addFiles($fileOrFiles)
    {
        if (!$fileOrFiles) return;

        self::init();
        $files = self::$storage->get(self::FILES_KEY);

        if (!is_array($files)) {
            $files = array();
        }
        if (!is_array($fileOrFiles)) {
            $fileOrFiles = array($fileOrFiles);
        }

        foreach ($fileOrFiles as $file) {
            if (!in_array($file, $files)) {
                FileChecks::warnIfFileNotExists($file);
                $files[] = $file;
            }
        }
        self::$storage->set(self::FILES_KEY, $files);
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function removeFile($fileOrFiles)
    {
        self::init();
        $files = self::$storage->get(self::FILES_KEY);
        if (!is_array($files) || count($files) === 0) return;

        if (!is_array($fileOrFiles)) {
            $fileOrFiles = array($fileOrFiles);
        }

        $modified = false;
        foreach ($fileOrFiles as $file) {
            if (($key = array_search($file, $files)) !== false) {
                unset($files[$key]);
                $modified = true;
            }
        }

        if ($modified) {
            self::$storage->set(self::FILES_KEY, $files);
        }
    }

    /**
     * @return array
     */
    public static function getFiles()
    {
        self::init();
        $files = self::$storage->get(self::FILES_KEY);
        if (!is_array($files)) {
            $files = array();
        }
        return $files;
    }

    /**
     * @param array|string $fileOrFiles
     * @return void
     */
    public static function setFiles($fileOrFiles) {
        self::init();

        if (!$fileOrFiles) {
            $fileOrFiles = array();
        } elseif (!is_array($fileOrFiles)) {
            $fileOrFiles = array($fileOrFiles);
        }

        foreach ($fileOrFiles as $file) {
            FileChecks::warnIfFileNotExists($file);
        }

        self::$storage->set(self::FILES_KEY, $fileOrFiles);
    }
}
