<?php

use ifes\ConfigStorageArea;

abstract class BackButton
{
    const TEXT_KEY = "text";
    const VISIBLE_KEY = "visible";

    /* @var $storage ConfigStorageArea */
    private static $storage;

    private static function init()
    {
        if (!self::$storage) {
            self::$storage = new ConfigStorageArea(get_called_class());
        }
    }

    public static function setText($text)
    {
        self::init();
        self::$storage->set(self::TEXT_KEY, $text);
    }

    public static function getText()
    {
        self::init();
        return self::$storage->get(self::TEXT_KEY);
    }

    public static function hide()
    {
        self::init();
        self::$storage->set(self::VISIBLE_KEY, false);
    }

    public static function show()
    {
        self::init();
        self::$storage->set(self::VISIBLE_KEY, true);
    }

    public static function isVisible()
    {
        self::init();
        return (bool)self::$storage->get(self::VISIBLE_KEY);
    }
}