<?php

use ifes\ConfigStorageArea;
//TODO Defaults
abstract class Appointment
{
    const DATE_PICKER_MAX_DATE = "date_picker_max_date";
    const DATE_PICKER_MIN_TIME = "date_picker_min_time";
    const DATE_PICKER_MAX_TIME = "date_picker_max_time";
    const DATE_PICKER_INTERVAL = "date_picker_interval";
    const PHONENUMBER_PLACEHOLDER = "phonenumber_placeholder";


    /* @var $storage ConfigStorageArea */
    private static $storage;

    private static function init()
    {
        if (!self::$storage) {
            self::$storage = new ConfigStorageArea(get_called_class());
        }
    }

    public static function setMaxDate($date)
    {
        self::init();
        self::$storage->set(self::DATE_PICKER_MAX_DATE, $date);
    }

    public static function getMaxDate()
    {
        self::init();
        return self::$storage->get(self::DATE_PICKER_MAX_DATE);
    }

    public static function setMinTime($time)
    {
        self::init();
        self::$storage->set(self::DATE_PICKER_MIN_TIME, $time);
    }

    public static function getMinTime()
    {
        self::init();
        return self::$storage->get(self::DATE_PICKER_MIN_TIME);
    }

    public static function setMaxTime($time)
    {
        self::init();
        self::$storage->set(self::DATE_PICKER_MAX_TIME, $time);
    }

    public static function getMaxTime()
    {
        self::init();
        return self::$storage->get(self::DATE_PICKER_MAX_TIME);
    }

    public static function setTimePickerInterval($minutes)
    {
        self::init();
        self::$storage->set(self::DATE_PICKER_INTERVAL, $minutes);
    }

    public static function getTimePickerInterval()
    {
        self::init();
        return self::$storage->get(self::DATE_PICKER_INTERVAL);
    }

    public static function setPhonenumberPlaceholder($text)
    {
        self::init();
        self::$storage->set(self::PHONENUMBER_PLACEHOLDER, $text);
    }

    public static function getPhonenumberPlaceholder()
    {
        self::init();
        return self::$storage->get(self::PHONENUMBER_PLACEHOLDER);
    }
}