<?php
include_once(IFES_ROOT_DIR . 'php/config/IfesLabelValueConfig.php');
include_once(IFES_ROOT_DIR . 'php/config/IfesCallStatusConfig.php');

/**
 * Konfiguration der tStatus Seite (CATI)
 */
interface IfesTStatusConfig
{
    /**
     * Konfiguration von ProjektInfo
     * 
     * @return IfesLabelValueConfig
     */
    function projectInfo();

    /**
     * Konfiguration von TelInfo
     * 
     * @return IfesLabelValueConfig
     */
    function telInfo();

    /**
     * Konfiguration von CallStatus (Kontaktergebnis)
     * 
     * @return IfesCallStatusConfig
     */
    function callStatus();

    /**
     * Hilfetext neben Telefonnummer anzeigen
     * 
     * @param string $text Hilfetext, der angezeigt werden soll.
     * @return IfesTStatusConfig
     */
    function withTelNrHelpText($text);

    /**
     * Keinen Hilfetext neben Telefonnummer anzeigen (DEFAULT)
     * 
     * @return IfesTStatusConfig
     */
    function withoutTelNrHelpText();

    /**
     * Hilfetext neben CallStatus (Kontaktergebnis) anzeigen
     * 
     * @param string $text Hilfetext, der angezeigt werden soll.
     * @return IfesTStatusConfig
     */
    function withCallResultHelpText($text);

    /**
     * Keinen Hilfetext neben CallStatus (Kontaktergebnis) anzeigen (DEFAULT)
     * 
     * @return IfesTStatusConfig
     */
    function withoutCallResultHelpText();


    /**
     * Submit-On-Enter auf tStatus Seite aktivieren
     * 
     * @return IfesTStatusConfig
     */
    function withSubmitOnEnter();

    /**
     * Submit-On-Enter auf tStatus Seite deaktivieren (DEFAULT)
     * 
     * @return IfesTStatusConfig
     */
    function withoutSubmitOnEnter();

    /**
     * Caller-Name auf tStatus Seite anzeigen (DEFAULT)
     *
     * @return IfesTStatusConfig
     */
    function withCallerName();

    /**
     * Caller-Name auf tStatus Seite nicht anzeigen
     *
     * @return IfesTStatusConfig
     */
    function withoutCallerName();
}

interface IfesTStatusConfigInternal extends IfesTStatusConfig
{
    function telNrHelpText();
    function callResultHelpText();
    function submitOnEnter();
    function showCallerName();
}

class IfesTStatusConfigImpl implements IfesTStatusConfigInternal
{
    const DEFAULT_PROJECT_INFO_LABELS = [
        'Project ID' => 'Projekt ID',
        'Interview ID' => 'Interview ID',
        'Telephone number ID' => 'TelNr ID',
        'Number of calls' => 'Anzahl Anrufe',
    ];

    const DEFAULT_TEL_INFO_LABELS = [
        'oms' => 'Vorwahl',
        'telephone' => 'Telefon',
        'region' => 'Region',
        'address' => 'Adresse',
        'zip' => 'Plz',
        'town' => 'Ort',
        'name' => 'Name'
    ];

    private $projectInfo;
    private $telInfo;
    private $callStatus;
    private $telNrHelpText;
    private $callResultHelpText;
    private $submitOnEnter;

    private $showCallerName;

    function __construct()
    {
        $this->projectInfo = new IfesLabelValueConfigImpl(self::DEFAULT_PROJECT_INFO_LABELS);
        $this->telInfo = new IfesLabelValueConfigImpl(self::DEFAULT_TEL_INFO_LABELS);
        $this->callStatus = new IfesCallStatusConfigImpl([]);
        $this->telNrHelpText = null;
        $this->submitOnEnter = false;
        $this->showCallerName = true;
    }

    public function projectInfo()
    {
        return $this->projectInfo;
    }

    public function telInfo()
    {
        return $this->telInfo;
    }

    public function callStatus()
    {
        return $this->callStatus;
    }

    public function withTelNrHelpText($text)
    {
        $this->telNrHelpText = $text;
        return $this;
    }

    public function withoutTelNrHelpText()
    {
        $this->telNrHelpText = null;
        return $this;
    }

    public function withCallResultHelpText($text)
    {
        $this->callResultHelpText = $text;
        return $this;
    }

    public function withoutCallResultHelpText()
    {
        $this->callResultHelpText = null;
        return $this;
    }

    public function withSubmitOnEnter()
    {
        $this->submitOnEnter = true;
        return $this;
    }

    public function withoutSubmitOnEnter()
    {
        $this->submitOnEnter = false;
        return $this;
    }

    function withCallerName()
    {
        $this->showCallerName = true;
        return $this;
    }

    function withoutCallerName()
    {
        $this->showCallerName = false;
        return $this;
    }

    public function telNrHelpText()
    {
        return $this->telNrHelpText;
    }

    public function callResultHelpText()
    {
        return $this->callResultHelpText;
    }

    public function submitOnEnter()
    {
        return $this->submitOnEnter;
    }

    function showCallerName()
    {
        return $this->showCallerName;
    }
}
