<?php
include_once(WARPIT_ROOT_DIR . "_support/class.db.php");
include_once(IFES_ROOT_DIR . 'php/misc/IfesHelper.php');

/**
 * Konfiguration der Progressbar
 */
interface IfesProgressbarConfig
{
    /**
     * Progressbar anzeigen
     * 
     * @return IfesProgressbarConfig
     */
    function enable();

    /**
     * Progressbar ausblenden (DEFAULT)
     * 
     * @return IfesProgressbarConfig
     */
    function disable();

    /**
     * Fortschritt in Prozent anzeigen
     * 
     * @return IfesProgressbarConfig
     */
    function withPercentage();

    /**
     * Fortschritt in Prozent ausblenden (DEFAULT)
     * 
     * @return IfesProgressbarConfig
     */
    function withoutPercentage();

    /**
     * Konfiguration für Berechnung des Fortschritts
     * 
     * @param array $steps Liste der Fragen, die für die Berechnung
     *                     des Fortschritts herangezogen werden sollen
     * @return IfesProgressbarConfig
     */
    function withSteps($steps);
}

class IfesProgressbarConfigImpl implements IfesProgressbarConfig
{
    const VAR_PROGRESSBAR = 'progressbar';

    private $db;
    private $questionnaire;

    public $enabled;
    public $template;
    public $showPct;
    public $steps;

    function __construct($db, $questionnaire)
    {
        $this->db = $db;
        $this->questionnaire = $questionnaire;
        $this->enabled = false;
        $this->template = '<div class="ifes-progressbar"><div><div>[!progresstext!]</div><div style="width:[!progress!]"><div>[!progresstext!]</div></div></div></div>';
        $this->showPct = false;
    }

    public function enable()
    {
        $this->enabled = true;
        return $this;
    }

    public function disable()
    {
        $this->enabled = false;
        return $this;
    }

    public function withPercentage()
    {
        $this->showPct = true;
        return $this;
    }

    public function withoutPercentage()
    {
        $this->showPct = false;
        return $this;
    }

    public function withSteps($steps)
    {
        $this->steps = $steps;
        return $this;
    }

    private function createProgressbarHtml()
    {
        if (!$this->enabled) return '';

        if (!empty($this->steps)) {
            // manual progress
            $stepCount = count($this->steps) + 1;
            $idCurrentQuestion = explode('/', $_SESSION['currentRotationString'])[1];
            if (!$idCurrentQuestion) $idCurrentQuestion = 0;

            $sql = 'SELECT t1.id_question as id, t1.idLab as qname FROM ';
            $sql .= DB_WARPIT_WEBCATI . '.' . $this->questionnaire->projname . '_tree t1 LEFT OUTER JOIN ';
            $sql .= DB_WARPIT_WEBCATI . '.' . $this->questionnaire->projname . '_tree t2 ON t1.id_sup = t2.id ';
            $sql .= 'WHERE t1.is_leaf = 1 AND (t1.id_question = ' . $idCurrentQuestion . " OR t1.idLab in ('" . implode("','", $this->steps) . "'))";
            $sql .= 'ORDER BY IFNULL(t2.orderBy, t1.orderBy), CASE WHEN ISNULL(t2.orderBy) THEN 0 ELSE t1.orderBy END';

            $res = $this->db->SQLexecute($sql);

            $currentStep = -1;
            while ($row = $this->db->fetchAssoc($res)) {
                if (in_array($row['qname'], $this->steps)) $currentStep++;
                if ($row['id'] == $idCurrentQuestion) {
                    $currentStep++;
                    break;
                }
            }
            if ($currentStep < 0) $currentStep = 0;

            $progress = round($currentStep / $stepCount * 100);
        } else {
            // calculated progress
            global $qVar;

            if ($this->questionnaire && $qVar['q_pos'] > 0) {
                $qPositionAndAll = $this->questionnaire->getQuestionPosition();
                $qPos = $qPositionAndAll[0];
                $qAll = $qPositionAndAll[1];
            } else if (!$this->questionnaire) //question preview
            {
                $qPos = 4;
                $qAll = 10;
            } else
                return '';
            $progress = round($qPos / $qAll * 100);
        }

        $vars = array(
            '[!progress!]' => $progress . '%',
            '[!progresstext!]' => ($this->showPct ? $progress . '%' : '')
        );
        return strtr($this->template, $vars);
    }

    public function initVariables()
    {
        IfesHelper::setDesignerVariable(self::VAR_PROGRESSBAR, $this->createProgressbarHtml());
    }
}
