<?php

/**
 * Konfiguration der CallStatus (Kontaktergebnis) Optionen (CATI)
 */
interface IfesCallStatusConfig
{
    function enable();
    function disable();
    /**
     * Labels ohne Mapping anzeigen (DEFAULT)
     * 
     * @return IfesCallStatusConfig
     */
    function withUnmapped();

    /**
     * Labels ohne Mapping ausblenden
     * 
     * @return IfesCallStatusConfig
     */
    function withoutUnmapped();

    /**
     * Standard-Mapping von Labels verwenden (DEFAULT)
     * 
     * @return IfesCallStatusConfig
     */
    function withDefaultMapping();

    /**
     * Standard-Mapping von Labels ignorieren
     * 
     * @return IfesCallStatusConfig
     */
    function withoutDefaultMapping();
    /**
     * Text von Warpit durch eigenen Text ersetzen
     * Die Reihenfolge der Aufrufe bestimmt die Reihenfolge der angezeigten Optionen.
     * 
     * @param string $warpitLabel Text der ersetzt werden soll
     * @param string $newLabel     Neuer Text
     */
    function map($warpitLabel, $newLabel);
}

interface IfesCallStatusConfigInternal extends IfesCallStatusConfig
{
    function process($inputTags);
}

class IfesCallStatusConfigImpl implements IfesCallStatusConfigInternal
{
    private $enabled = true;
    private $skipUnmapped = false;
    private $ignoreDefaultMapping = false;
    private $mapping = array();
    private $defaultMapping;

    function __construct($defaultMapping)
    {
        $this->defaultMapping = $defaultMapping;
    }

    public function map($warpitLabel, $newLabel = true)
    {
        if ($newLabel === true) $newLabel = $warpitLabel;
        $this->mapping[$warpitLabel] = $newLabel;
        return $this;
    }

    public function enable()
    {
        $this->enabled = true;
        return $this;
    }

    public function disable()
    {
        $this->enabled = false;
        return $this;
    }

    public function withUnmapped()
    {
        $this->skipUnmapped = false;
        return $this;
    }

    public function withoutUnmapped()
    {
        $this->skipUnmapped = true;
        return $this;
    }

    public function withDefaultMapping()
    {
        $this->ignoreDefaultMapping = false;
        return $this;
    }

    public function withoutDefaultMapping()
    {
        $this->ignoreDefaultMapping = true;
        return $this;
    }

    /** @noinspection DuplicatedCode */
    public function process($inputTags)
    {
        if (!$this->enabled) return false;
        $mapping = $this->mapping;
        if (!$this->ignoreDefaultMapping) {
            foreach ($this->defaultMapping as $property => $defaultLabel) {
                if (!array_key_exists($property, $mapping)) {
                    $mapping[$property] = $defaultLabel;
                }
            }
        }

        $mappedTags = array();
        $tags = array();

        foreach ($mapping as $label => $mappedLabel) {
            foreach ($inputTags as $tag) {
                $search = '>' . $label . '<';
                if (str_contains($tag, $search)) {
                    $mappedTags[$mappedLabel] = str_replace($search, '>' . $mappedLabel . '<', $tag);
                    $tags[] = $tag;
                    break;
                }
            }
        }

        if (!$this->skipUnmapped) {
            foreach ($inputTags as $tag) {
                if (!in_array($tag, $tags)) $mappedTags[] = $tag;
            }
        }

        return $mappedTags;
    }
}
