<?php

interface IfesAppointmentConfig {
    function withDatePickerMaxDate($date);

    function withTimePickerMinTime($time);

    function withTimePickerMaxTime($time);

    function withPhonenumberPlaceholder($placeholder);

    function withoutPhonenumberPlaceholder();

    function withTimePickerInterval($minutes);

    function withBeforeSubmitJS($js);
}

interface IfesAppointmentConfigInternal extends IfesAppointmentConfig {
    function getParams();
}

class IfesAppointmentParams {
    private $now;
    private $dpTimeInterval;
    private $dpMaxDate;
    private $dpMinDate;
    private $dpMaxTime;
    private $dpMinTime;
    private $warpitDate;
    private $deDate;
    private $dpDate;
    private $time;
    private $normalizedTime;
    private $phonenumberPlaceholder;
    private $beforeSubmitJS;

    /**
     * @throws Exception
     */
    public function __construct($dpMaxDate, $dpMinTime, $dpMaxTime, $dpTimeInterval, $phonenumberPlaceholder, $beforeSubmitJS)
    {
        $now = new DateTime('now');
        $normalizedNow = new DateTime('now');
        $delta = $dpTimeInterval - $normalizedNow->format('i') % $dpTimeInterval;
        $normalizedNow->add(new DateInterval('PT' . $delta . 'M'));

        $this->now = $now;
        $this->dpTimeInterval = $dpTimeInterval;
        $this->dpMinTime = $dpMinTime;
        $this->dpMaxTime = $dpMaxTime;
        $this->dpMinDate = $normalizedNow->format('d-m-Y H:i');
        $this->dpMaxDate = $dpMaxDate;
        $this->warpitDate = $now->format('d-m-Y');
        $this->deDate = $now->format('d.m.Y');
        $this->dpDate = $now->format('Y/m/d');
        $this->time = $now->format('H:i');
        $this->normalizedTime = $normalizedNow->format('H:i');

        $this->phonenumberPlaceholder = $phonenumberPlaceholder;
        $this->beforeSubmitJS = $beforeSubmitJS;
    }

    /**
     * @return DateTime
     */
    public function now()
    {
        return $this->now;
    }

    /**
     * @return mixed
     */
    public function dpMaxDate()
    {
        return $this->dpMaxDate;
    }

    /**
     * @return string
     */
    public function dpMinDate()
    {
        return $this->dpMinDate;
    }

    /**
     * @return mixed
     */
    public function dpMaxTime()
    {
        return $this->dpMaxTime;
    }

    /**
     * @return mixed
     */
    public function dpMinTime()
    {
        return $this->dpMinTime;
    }

    /**
     * @return string
     */
    public function warpitDate()
    {
        return $this->warpitDate;
    }

    /**
     * @return string
     */
    public function deDate()
    {
        return $this->deDate;
    }

    /**
     * @return string
     */
    public function dpDate()
    {
        return $this->dpDate;
    }

    /**
     * @return string
     */
    public function time()
    {
        return $this->time;
    }

    /**
     * @return string
     */
    public function normalizedTime()
    {
        return $this->normalizedTime;
    }

    /**
     * @return mixed
     */
    public function phonenumberPlaceholder()
    {
        return $this->phonenumberPlaceholder;
    }

    /**
     * @return mixed
     */
    public function dpTimeInterval()
    {
        return $this->dpTimeInterval;
    }

    public function beforeSubmitJS()
    {
        return $this->beforeSubmitJS;
    }
}


class IfesAppointmentConfigImpl implements IfesAppointmentConfigInternal {

    const DEFAULT_PHONENUMBER_PLACEHOLDER = 'z.B. 06641234567';
    const DEFAULT_TIMEPICKER_INTERVAL = 5;
    private $timePickerInterval;
    private $maxDate;
    private $minTime;
    private $maxTime;
    private $phonenumberPlaceholder;

    private $beforeSubmitJS;

    public function __construct()
    {
        $this->maxDate = date('Y-m-d', strtotime('+1 year'));
        $this->minTime = 6;
        $this->maxTime = 22;
        $this->timePickerInterval = 5;
        $this->phonenumberPlaceholder = self::DEFAULT_PHONENUMBER_PLACEHOLDER;
    }

    public function withDatePickerMaxDate($date)
    {
        $this->maxDate = $date;
        return $this;
    }

    public function withTimePickerMinTime($time)
    {
        $this->minTime = $time;
        return $this;
    }

    public function withTimePickerMaxTime($time)
    {
        $this->maxTime = $time;
        return $this;
    }

    public function withPhonenumberPlaceholder($placeholder)
    {
        $placeholder = trim($placeholder);
        if (!$placeholder) $placeholder = self::DEFAULT_PHONENUMBER_PLACEHOLDER;
        $this->phonenumberPlaceholder = $placeholder;
        return $this;
    }

    public function withoutPhonenumberPlaceholder()
    {
        $this->phonenumberPlaceholder = '';
        return $this;
    }

    public function withTimePickerInterval($minutes)
    {
        if (!$minutes || $minutes < 0) $minutes = self::DEFAULT_TIMEPICKER_INTERVAL;
        $this->timePickerInterval = $minutes;
        return $this;
    }

    /**
     * @throws Exception
     */
    public function getParams() {
        return new IfesAppointmentParams(
            $this->maxDate,
            $this->minTime,
            $this->maxTime,
            $this->timePickerInterval,
            $this->phonenumberPlaceholder,
            $this->beforeSubmitJS);
    }

    function withBeforeSubmitJS($js)
    {
        $this->beforeSubmitJS = $js;
    }
}