<?php /** @noinspection CommaExpressionJS */
/** @noinspection HtmlUnknownAttribute */
include_once(WARPIT_ROOT_DIR . "_support/class.db.php");
include_once(IFES_ROOT_DIR .'php/config/IfesConfig.php');

class IfesDesignV1 {

    const IFES_DESIGN_NAME = 'IFES_responsive';
    const REGEX_TAG = '/(?:<tr>)?<td[^>]*id="([^"]*)"[^>]*paneltype=(\d+)(?:[^>](?!display))*(?:;?display\s*:\s*(ifes-[^;]*);)?[^>]*>(.*)/is';
    const REGEX_STYLE = '/\sstyle=["\'][^"\']*["\']/i';
    const REGEX_LABEL_VALUES = '/^([^:]+):(.*)$/i';
    const HTML_PARSE_ERROR_CSS_CLASS = 'ifes-error-html-parser';
    const KNOWN_PANELTYPES = [
        3 => 'question',
        4 => 'instruction',
        6 => 'answer',
        7 => 'variable',
        11 => 'back',
        19 => 'text',
        10 => 'submit',
        24 => 'hangup',
        25 => 'cancel-interview',
        27 => 'quota',
        28 => 'interviewer-id',
        29 => 'project-info',
        30 => 'tel-structure-data',
        31 => 'call-status',
        33 => 'appointment',
        35 => 'dialer',
        38 => 'phone-number',
        39 => 'caller-name',
        40 => 'error',
        41 => 'go-to-idle',
        42 => 'make-appointment',
        46 => 'appointment-comment',
        54 => 'appointment-call-time',
        57 => 'script',
        63 => 'interviewer-username'
    ];

    private $enabled = false;

    private $db;
    private $config;
    private $questionnaire;
    private $htmlWrapperClass;
    private $questionName;
    /** @noinspection PhpPropertyOnlyWrittenInspection */
    private $questionId;
    private $testInterview = false;


    function __construct($db, $questionnaire) {
        $this->db = $db;
        $this->config = new IfesConfigImpl($db, $questionnaire);
        if ($_SESSION['testSurvey']) $this->testInterview = true;

        if ($questionnaire) {
            $this->questionnaire = $questionnaire;

            // enable IfesDesign only if responsive template is used anywhere in project
            $projectId = $this->questionnaire->id_project;
            $sql = "SELECT 1 FROM " . DB_WARPIT_WEBCATI_BASE . "._DesignerManager dm INNER JOIN " . DB_WARPIT_WEBCATI_BASE . "._DesignerTemplates dt ON dm.id_template = dt.id ";
            $sql .= "WHERE dm.id_project = " . $projectId . " AND dm.type_device=0 AND dt.name LIKE '" . self::IFES_DESIGN_NAME . "%' limit 1";
            $this->enabled = $this->db->fetchAssoc($this->db->SQLexecute($sql))[1] == 1;
        }
    }

    public function getConfig() {
        return $this->config;
    }

    public function initVariables() {
        if (!$this->enabled()) return;
        
        $this->config->initVariables();
        $templateId = $this->questionnaire->display->getIdTemplate();
        $templateName = trim((string)$this->db->get(DB_WARPIT_WEBCATI_BASE . "._DesignerTemplates", $templateId, "name"));
        $this->htmlWrapperClass =  strtolower(str_replace('_', '-', str_replace(' ', '', $templateName)));
    }

    public function setQuestion($question) {
        $this->questionId = $question['id'];
        $this->questionName = $question['q_name'];
    }

    public function enabled() {
        return $this->enabled;
    }

    public function writeCssLinks() {
        if (!$this->enabled()) return;
        foreach($this->config->getCssFiles() as $css) {
            echo "<link rel=\"stylesheet\" href=\"" . $css . "\" type=\"text/css\" />";
        }
    }

    public function writeScriptTags() {
        if (!$this->enabled()) return;
        foreach($this->config->getJsFiles() as $js) {
            echo "<script type=\"text/javascript\" src=\"$js\"></script>";
        }
    }

    public function writeHeader() {
        if (!$this->enabled()) return;
        echo $this->config->header()->getHtml();
    }

    public function writeWrapperStartTag() {
        if (!$this->enabled()) return;
        echo '<div class="ifes-responsive ' . $this->htmlWrapperClass . '">';
        $this->config->validateApiVersion();

        if ($this->testInterview && $this->config->getTestMsg())
            echo "<div class=\"ifes-test-interview-warning\">" . $this->config->getTestMsg() . "</div>";
    }

    public function writeWrapperEndTag() {
        if (!$this->enabled()) return;
        echo '</div>';
    }

    /**
     * @throws Exception
     */
    public function processXmlTemplate($display, $xmlObj, $parType, $lastChild, $parId = null) {
        if (!$this->enabled()) return $display->displayChilds($xmlObj,$parType,$lastChild, $parId);

        $html = '';
        $attr = $xmlObj->attributes();
        $paneltype = $attr['type'];

        // 1 = horizontal, 2 = vertical
        if($paneltype == 1 || $paneltype == 2) {
            $css = $this->getCssFromDb($attr['RMclass']);
            if ($css) $css = ' class="' . $css . '"';
            $html .= "<div $css>";
            foreach($xmlObj->children() as $child) {
                $html .= $this->processXmlTemplate($display, $child, $parType, $lastChild, $parId);
            }
            $html .= '</div>';
        } else if ($paneltype == 47) {

            $templateName = null;
	  		$sql = "SELECT name FROM " . DB_WARPIT_WEBCATI_BASE . "._DesignerTemplates WHERE id = ".$attr['id_template'];
            if(!$rs = $this->db->SQLexecute($sql)) echo $this->db->GetError();
            if($row = $this->db->fetchRow($rs))
            {
                $templateName = $row[0];
            }
            $html = $display->displayChilds($xmlObj, $parType, $lastChild, $parId);
            $css = strtolower(str_replace('_', '-', $templateName));
            return $this->processHtml($html, $css);
        } else {
            $html .= $this->processHtml($display->displayChilds($xmlObj,$parType,$lastChild, $parId));
        }
		return $html;
    }

    /**
     * @throws Exception
     */
    public function processHtml($html, $cssClass = null) {
        if (!$this->enabled()) return $html;

        $pHtml = trim($html);
        if ($pHtml == '') return '';
        if (preg_match(self::REGEX_TAG, $pHtml, $matches)) {
            $elementId = $matches[1];
            $paneltype = $matches[2];

            if (substr($matches[3], 0, 5) == 'ifes-') {
                $cssClass = trim($matches[3]);
            }

            if (!$cssClass) $cssClass = $this->getCssClass($paneltype);
            $pHtml = $this->processPanel($paneltype, $matches[4]);

            if ($pHtml === false) {
                $pHtml = $this->htmlParseError($html);
            } else {
                $pHtml = "\n<div id=\"" . $elementId . '" paneltype="' . $paneltype . '" class="ifes-panel ' . $cssClass . "\">" . $pHtml . "</div>\n";
            }
        } else {
            $pHtml = $this->htmlParseError($html);
        }
        return $pHtml;
    }

    private function getCssFromDb($classes) {
        $cssClasses = '';
        if ($classes) {
            $sql = "SELECT b.prop_value FROM " . DB_WARPIT_WEBCATI_BASE . "._DesignerCssProperties a INNER JOIN " . DB_WARPIT_WEBCATI_BASE . "._DesignerClsPropLink b ON a.id = b.id_property WHERE a.name='display' AND id_class in ($classes)";
            $rs = $this->db->SQLexecute($sql);
            while ($row = $this->db->fetchAssoc($rs))
            {
                $cssClasses .= ' ' . $row['prop_value'];
            }
        } 
        return trim($cssClasses);
    }


    /**
     * @throws Exception
     */
    private function processPanel($paneltype, $html) {
        //$html = trim(preg_replace(self::REGEX_STYLE, '', [$html], 1)[0]);

        switch($paneltype) {
            case 3: // question
            case 4: // instruction
            case 6: // answers
            case 7: // variable
            case 19: // textbox
            case 27: // quota
            case 35: // dialer
            case 40: // leave/error text
            case 57: // script
                return $html;

            case 47:
                return trim(preg_replace(self::REGEX_STYLE, '', [$html])[0]);

            case 10: // submit
            case 11: // back
            case 25: // cancel interview
            case 42: // make appointment
                if (!trim($html)) return '';
                if (!preg_match('/(?:(<input.*class\s*=\s*["\'][^"\']*)(["\'].*)|(<input))(.*)/is', $html, $matches)) return false;
                $css = (array_key_exists($paneltype, self::KNOWN_PANELTYPES) ? self::KNOWN_PANELTYPES[$paneltype] : 'unknown');
                $css = "ifes-btn ifes-btn-$css";
                $disabled = '';
                if ($paneltype == 11 && $this->config->buttons()->isBackButtonHidden()) {
                    $css .= ' ifes-hidden';
                } elseif ($paneltype == 42 && $this->testInterview) {
                    $disabled = 'disabled';
                }
                if ($matches[1]) {
                    $html = "$matches[1] $disabled $css $matches[2]";
                } else {
                    $html = "$matches[3] $disabled class=\"$css\"$matches[4]";
                }
                $html = str_replace('Are you sure?', 'Sind Sie sicher?', $html);
                if ($paneltype == 10 && $this->questionName == 'tStatus' && $this->config->tStatus()->submitOnEnter()) {
                    //TODO test
                    $html .= "<script> document.addEventListener('keypress', (event)=>{ if (event.key === 'Enter') $('#submitCallStatus').click(); });</script>";
                }
                return $html;
            case 24: //hangup
                $config = $this->config->buttons();
                if ($config->isHangupButtonHidden()) return '';
                return '<button type="button" class="ifes-btn ifes-btn-hangup" name="hangupButton" id="hangupButton">' . $config->getHangupButtonText() . '</button>';

            case 28: // interviewer id
                if ($html == '') return $html;
                if (!preg_match(self::REGEX_LABEL_VALUES, $html, $matches)) return false;
                return $this->getLabelValueHtml($paneltype, ["Interviewer ID" => $matches[2]], false);

            case 29: // project info
                $config = $this->config->tStatus()->projectInfo();
                /** @noinspection DuplicatedCode */
                $lines = explode('<br>', $html);
                $items = array();
                foreach($lines as $line) {
                    if (trim($line) == '') continue;
                    if (!preg_match(self::REGEX_LABEL_VALUES, $line, $matches)) return false;
                    $label = trim($matches[1]);
                    $value = trim($matches[2]);
                    $items[$label] = $value;
                }
                $items = $config->process($items);
                return empty($items) ? '' : $this->getLabelValueHtml($paneltype, $items, false);

            case 30: // tel structure data
                $config = $this->config->tStatus()->telInfo();
                /** @noinspection DuplicatedCode */
                $lines = explode('<br>', $html);
                $items = array();
                foreach($lines as $line) {
                    if (trim($line) == '') continue;
                    if (!preg_match(self::REGEX_LABEL_VALUES, $line, $matches)) return false;
                    $label = trim($matches[1]);
                    $value = trim($matches[2]);
                    $items[$label] = $value;
                }
                $items = $config->process($items);
                return empty($items) ? '' : $this->getLabelValueHtml($paneltype, $items, false);
                
            case 31: // call status
                $config = $this->config->tStatus()->callStatus();
                $scriptStart = strpos($html, '<script');
                $script = substr($html, $scriptStart);
                $html = substr($html, 0, $scriptStart -1);
                $html = trim(str_replace(["\n","\r","\r\n","\n\r"], '', $html));
                $inputTags = explode('<br>', $html);
                unset($inputTags[0]);

                $oTag = '<div class="ifes-input-wrapper">';
                $helpText = $this->config->tStatus()->callResultHelpText();
                if ($helpText) {
                    $helpText = '<span class="ifes-help ifes-call-status-help">' . $helpText . '</span>';
                }
                $header = '<div class="ifes-p-call-status-header">Kontaktergebnis' . $helpText . '</div>';
                
                $inputTags = $config->process($inputTags);
                return $header . '<div class="ifes-p-call-status-items">' . $oTag . implode('</div>' . $oTag, $inputTags) . $script . '</div></div>';

            case 33: // appointment
                $config = $this->config->appointment()->getParams();
                $dpStep = $config->dpTimeInterval();
                $dpMinTime = $config->dpMinTime();
                $dpMaxTime = $config->dpMaxTime();
                $dpMinDate = $config->dpMinDate();
                $dpMaxDate = $config->dpMaxDate();

                $warpitDate = $config->warpitDate();
                $deDate = $config->deDate();
                $dpDate = $config->dpDate();
                $time = $config->time();
                $normalizedTime = $config->normalizedTime();

                $phonenumberPlaceholder = $config->phonenumberPlaceholder();
                $phonenumber = '';
                if($_SESSION['app_call_this_num'])
                    $phonenumber = join('', explode('/',$_SESSION['app_call_this_num']));
                $comment = strlen($_SESSION['app_koment']) > 0 ? $_SESSION['app_koment'] : $_SESSION['app_display_komment'];

                $submitOnEnterJS = '';
                if ($this->config->tStatus()->submitOnEnter()) {
                    $submitOnEnterJS= "document.addEventListener('keypress', (event)=>{ if (event.target.id !== 'dogovor_komentar' && event.key === 'Enter') $('#submitCallStatus').click(); });";
                }
                /** @noinspection BadExpressionStatementJS */
                /** @noinspection JSUnusedLocalSymbols */
                /** @noinspection ReservedWordAsName */
                /** @noinspection JSUnnecessarySemicolon */
                return <<<EOF
                    <script>
                        function warpitClientExecuteOnLoad() {
                            const errorMsg = $('#ifesErrorMsg');
                            const datetimepickerValue = $('#datetimepickerValue');
                            const datetimepickerHolder = $('#datetimepickerHolder');
                            const dateInput = $('#dateInput');
                            const phoneNrInput = $('#app_call_this_num');  

                            const validateAndSyncDate = function(date, updateDatePicker) {
                                dateInput.val(date.format('DD.MM.YYYY HH:mm'));

                                if (!date.isValid()) {
                                    errorMsg.text('Datum für Termin ist ungültig.').show();
                                    return false;
                                } else if (date < moment('$warpitDate $time', 'DD-MM-YYYY HH:mm')) {
                                    errorMsg.text('Der Termin liegt in der Vergangenheit.').show();
                                    return false;
                                } else if (date.hour() < $dpMinTime || date.hour() > $dpMaxTime || (date.hour() === $dpMaxTime && date.minute() > 0)) {
                                    errorMsg.text('Termine können nur zwischen {$dpMinTime}h und {$dpMaxTime}h vereinbart werden.').show();
                                    return false;
                                } else {
                                    // fix minutes to match step
                                    /*
                                    let delta = date.minutes() % $dpStep;
                                    delta = delta < ($dpStep / 2) ? delta * -1 : $dpStep - delta;
                                    let dpDate = date.add(delta, 'minutes');
                                     */

                                    dateInput.val(date.format('DD.MM.YYYY HH:mm'));
                                    datetimepickerValue.val(date.format('DD-MM-YYYY HH:mm'));
                                    
                                    if (updateDatePicker) {
                                        datetimepickerHolder.val(date.format('YYYY/MM/DD HH:mm'));
                                        datetimepickerHolder.blur();

                                        setTimeout(function() {
                                            let delta = date.minutes() % $dpStep;
                                            delta = delta < ($dpStep / 2) ? delta * -1 : $dpStep - delta;
                                            let dpDate = date.add(delta, 'minutes');
                                            const hours = dpDate.hours();
                                            const minutes = dpDate.minutes();
                                            const timeSlotCount = $('.xdsoft_time').length;
                                            const currentTimeSlot = $('.xdsoft_time.xdsoft_current');
                                            const currentTimeSlotIndex = currentTimeSlot.index();
                                            currentTimeSlot.removeClass('xdsoft_current');
                                            const selector = ".xdsoft_time[data-hour='" + hours + "'][data-minute='" + minutes + "']";
                                            $(selector).addClass('xdsoft_current');
                                            const timeSlots = $('.xdsoft_time_variant');
                                            let offset = 3;
                                            if (currentTimeSlotIndex > timeSlotCount - 6) offset = 6;
                                            let timeSlotsMargin = -1 * (currentTimeSlotIndex - offset) * timeSlots.height() / timeSlotCount;
                                            if (timeSlotsMargin > 0) timeSlotsMargin = 0;

                                            const timebox = $('.xdsoft_time_box');
                                            const scrollbar = timebox.find('.xdsoft_scroller');
                                            const scrollbarMargin = (timebox.find('.xdsoft_scrollbar').height() - scrollbar.height()) / timeSlotCount * currentTimeSlotIndex;

                                            scrollbar.css('margin-top', scrollbarMargin);
                                            timeSlots.css('margin-top', timeSlotsMargin);
                                        }, 100);
                                
                                    }
                                    errorMsg.text('').hide();
                                    return true;
                                }
                            }

                            const validatePhoneNr = function() {
                                const nr = phoneNrInput.val().replace(/[\/-\s]/g, '');
                                if (nr !== '') {
                                    if (isNaN(+nr) || isNaN(parseInt(nr))) {
                                        errorMsg.text('Telefonnummer muss numerisch sein.').show();
                                        return false;
                                    } else if (!nr.startsWith('0')) {
                                        errorMsg.text('Telefonnummer muss mit 0 beginnen.').show();
                                        return false;
                                    }
                                }
                                phoneNrInput.val(nr);
                                errorMsg.text('').hide();
                                return true;
                            }

                            datetimepickerHolder.datetimepicker({
                                inline:true,
                                minDate: '$dpMinDate',
                                maxDate: '$dpMaxDate',
                                minTime: '$dpMinTime:00',
                                maxTime: '$dpMaxTime:01',
                                lang:'de',
                                step:$dpStep,
                                dayOfWeekStart:1, 
                                onChangeDateTime : function(date) {
                                    validateAndSyncDate(moment(date), false);
                                }
                            });
                            dateInput.on('change', function() {
                                validateAndSyncDate(moment($(this).val(), 'DD.MM.YYYY HH:mm'), true);
                            });

                            $('#submitCallStatus').on('click', function(event) {
                                const date = moment(dateInput.val(), 'DD.MM.YYYY HH:mm');
                                if (!validateAndSyncDate(date) || !validatePhoneNr()) {
                                    event.preventDefault();
                                }
                            });

                            phoneNrInput.on('change', function() {
                                validatePhoneNr();
                            });
                            
                            $submitOnEnterJS
                        }
                    </script>
                    <input type="hidden" value="$warpitDate $normalizedTime" name="appDateTimeValue" id="datetimepickerValue">
                    <div class="ifes-error-msg" id="ifesErrorMsg" style="display: none;"></div>
                    <div class="ifes-make-appointment">
                        <div id="datetimepicker"><input type="text" value="$dpDate $normalizedTime" id="datetimepickerHolder"></div>
                        <label for="dateInput">Termin:</label>
                        <input type="text" value="$deDate $normalizedTime" name="appDateTimeDisplay" id="dateInput">
                        <label for="dogovor_komentar">Kommentar:</label>
                        <textarea onkeydown="arguments[0].stopPropagation()" name="dogovor_komentar" id="dogovor_komentar">$comment</textarea>
                        <label for="app_call_this_num">Neue Telefonnummer:</label>
                        <input type="text" name="app_call_this_num" maxlength="20" id="app_call_this_num" placeholder="$phonenumberPlaceholder" value="$phonenumber">
                        <!--span class="ifes-help ifes-make-appointment-phone-number-help">(z.B.: 06641234567)</-span-->
                    </div>
EOF;

            case 38: // phone number
                if ($html == '') return $html;
                $phonenumber = null;
                $id = null;
                if (preg_match('/<span\sid\s*=\s*["\']*([^"\'\s]+)["\']*\s*><a[^>]*>([^<]*)<.*/is', $html, $matches)) {
                    $id = trim($matches[1]);
                    $phonenumber = trim($matches[2]);
                } else if (preg_match(self::REGEX_LABEL_VALUES, $html, $matches)) {
                    $phonenumber = trim($matches[2]);
                }
                
                if (!$phonenumber) return false;
                if ($id) $id = ' id="' . $id . '"';
                $helpText = $this->config->tStatus()->telNrHelpText();
                if ($helpText) $helpText = '<span class="ifes-help ifes-phone-number-help">' . htmlspecialchars($helpText) . '</span>';

                return '<span' . $id . '><a href="callto:' . str_replace('/','',$phonenumber) . '">Tel: ' . $phonenumber . '</a></span>' . $helpText;

            case 39: // caller name
                if ($html == '' || ($this->config->nextQuestion() == 'tStatus' && !$this->config->tStatus()->showCallerName())) return '';
                if (!preg_match(self::REGEX_LABEL_VALUES, $html, $matches)) return false;
                $name = trim($matches[2]);
                if (!$name || $name == '-') return '';
                return "<span>$name</span>";

            case 41: // gotoIdle checkbox
                if ($html == '') return $html;
                if (!preg_match('/^<.*value=[\'"]*([0-9]*)[^>]*name=["\']*([^\'"]*).*>([^<]*)<br>(.*)$/is', $html, $matches)) return false;
                $value = trim($matches[1]);
                $name = trim($matches[2]);
                $text = trim($matches[3]);
                $select = trim($matches[4]);
                $checked = '';
                if ($_SESSION['gotoIdle']) $checked = 'checked';
                return "<div class=\"ifes-input-wrapper\"><input type=\"checkbox\" id=\"$name\" value=\"$value\" name=\"$name\" $checked><label for=\"$name\">$text</label></div><div>$select</div>";

            case 46: // appointment comment
                if ($html == '') return $html;
                if(!preg_match('/^<div[^>]+>(.*)<\/div>\s*$/is', $html, $matches)) return false;
                $comment = trim($matches[1]);
                if (!$comment) return '';
                return "<div>$comment</div>";

            case 54: // appointment call time
                if ($html == '') return $html;
                if (!preg_match('/.*([0-9]{4}\.[0-9]{2}\.[0-9]{2}\s[0-9]{2}:[0-9]{2}:[0-9]{2}).*/is', $html, $matches)) return false;
                $appointment = trim($matches[1]);
                if (!$appointment) return '';

                $appointment = date_format(date_create_from_format('Y.m.d H:i:s', $appointment), 'd.m.Y H:i');
                $displayText = "Erneuter Anwahlversuch";
                if ($_SESSION['app_exists']) {
                    $displayText = "Vereinbarter Termin";
                }
                return "<span>" . $displayText . ": " . $appointment . "</span>";

            case 63: // interviewer username
                $username = explode('_', $html)[0];
                return $this->getLabelValueHtml($paneltype, ["Kennung" => $username], false);
        } 

        return false;
    }

    private function htmlParseError($html) {
        return "\n<div class=\"" . self::HTML_PARSE_ERROR_CSS_CLASS . '"><table>' . $html . "</td></tr></table></div>\n";
    }

    private function getPanelName($paneltype) {
        return (array_key_exists($paneltype, self::KNOWN_PANELTYPES) ? self::KNOWN_PANELTYPES[$paneltype] : 'unknown');
    }

    private function getCssClass($paneltype) {
        return 'ifes-p-' . $this->getPanelName($paneltype);
    }

    /** @noinspection PhpSameParameterValueInspection */
    private function getLabelValueHtml($paneltype, $items, $skipEmpty, $id = null) {
        $cssClass = $this->getCssClass($paneltype);

        $html = '';
        foreach($items as $label => $value) {
            $value = trim($value);
            if ($skipEmpty && (!$value || $value == '')) continue;

            $label = trim($label);
            if ($id) $id = 'id="' . trim($id) . '"';
            $html .= '<span class="ifes-label ' . $cssClass . '-label">' . trim($label) . '</span>';
            $html .= '<span ' . $id . ' class="ifes-value ' . $cssClass . '-value">' . trim($value) . '</span>';
        }

        if ($html) $html = '<div class="ifes-listing ' . $cssClass . '-listing">' . $html . '</div>';
        return $html;
    }

}
